/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.scaffolding.internal;

import org.mule.apikit.scaffolding.api.ScaffoldingError;

import static java.util.Optional.ofNullable;

public class ScaffoldingErrorImpl implements ScaffoldingError {

  private String message;
  private Throwable cause;

  public ScaffoldingErrorImpl(String message) {
    this(null, message);
  }

  public ScaffoldingErrorImpl(Throwable cause) {
    this(cause, null);
  }

  public ScaffoldingErrorImpl(Throwable cause, String message) {
    this.cause = cause;
    this.message = message;
  }

  @Override
  public String cause() {
    return ofNullable(message).orElse("") + ". " + ofNullable(cause).map(Throwable::getMessage).orElse("");
  }
}
