%dw 2.0
input api application/json
output application/xml
import * from scripts::modules::ApiGraphModule
import * from scripts::modules::ScaffoldingModule
import * from scripts::modules::GeneratingQueriesModule
import every,firstWith from dw::core::Arrays
import toBoolean from dw::util::Coercions
import * from dw::core::Arrays
ns http http://www.mulesoft.org/schema/mule/http
ns munit http://www.mulesoft.org/schema/mule/munit
ns tools http://www.mulesoft.org/schema/mule/munit-tools

var flows =
    getNodeShapeTypes(api)
    flatMap (schema) ->
        getPropertiesFromSchema(api, schema)
        flatMap (property) ->
            getNotScalarPropertyTypes(api, property)
            flatMap getNodeShapeFromCompoundShape(api, $)
            filter !isEmpty($)
            flatMap "$(schema."shacl:name").$(property."shacl:name")"

fun munitTest(operationName) = munit#test @("name":joinBy([operationName,"Test"],"")):{
    munit#"enable-flow-sources" :{
        munit#"enable-flow-source" @(value: mainFlowName):{},
        (getOperationsNames(api) map ((operationName) ->
        munit#"enable-flow-source" @(value : operationName):{})),
        (flows map ((operationName) ->
        munit#"enable-flow-source" @(value : operationName):{})),
    },
    munit#execution: {
        http#request @(method : "POST", "config-ref":"HTTP_Request_configuration", path:"/graphql"):{
        http#body:
        getQueryByOperationName(operationName,api),
        http#headers :
            "#[{ 'Content-Type': 'application/json' }]"
        }},
    munit#validation: {
        tools#"assert-that" @(message: "The HTTP Status code is not correct!", expression:"#[attributes.statusCode]", "is":"#[MunitTools::equalTo(200)]"):{},
        tools#"assert-that" @(message: "The response payload is not correct!", expression:"#[payload]", "is":"#[MunitTools::notNullValue()]"):{}
    }
}

---
mule @("xmlns": "http://www.mulesoft.org/schema/mule/core",
    "xmlns:http": "http://www.mulesoft.org/schema/mule/http",
    "xmlns:graphql-router": "http://www.mulesoft.org/schema/mule/graphql-router",
    "xmlns:xsi": "http://www.w3.org/2001/XMLSchema-instance",
   "xmlns:munit":"http://www.mulesoft.org/schema/mule/munit",
   "xmlns:munit-tools":"http://www.mulesoft.org/schema/mule/munit-tools",
    "xsi:schemaLocation":
    "http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd http://www.mulesoft.org/schema/mule/http http://www.mulesoft.org/schema/mule/http/current/mule-http.xsd http://www.mulesoft.org/schema/mule/graphql-router http://www.mulesoft.org/schema/mule/graphql-router/current/mule-graphql-router.xsd http://www.mulesoft.org/schema/mule/munit http://www.mulesoft.org/schema/mule/munit/current/mule-munit.xsd http://www.mulesoft.org/schema/mule/munit-tools  http://www.mulesoft.org/schema/mule/munit-tools/current/mule-munit-tools.xsd",
    ): 
    
    {
        (munit#config @(name:"graphql-test-suite.xml"):{}),
        (http#"request-config" @(name:"HTTP_Request_configuration"):{
            http#"request-connection" @(host:"localhost", port:"8081"):{}}),
        (
        getOperationsNames(api) map ((operationName) -> 
                scaffoldElement(
                munitTest(operationName),
            []
    )))
       
}