/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.scaffolding.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.mule.apikit.scaffolding.api.Scaffolder;
import org.mule.apikit.scaffolding.api.ScaffoldingConfig;
import org.mule.apikit.scaffolding.api.ScaffoldingResult;
import org.mule.apikit.scaffolding.internal.ScaffoldingErrorImpl;
import org.mule.apikit.scaffolding.internal.ScaffoldingResultImpl;
import org.mule.apikit.scaffolding.internal.mapper.ApiGraphMapper;
import org.mule.apikit.scaffolding.internal.template.TemplateEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIKitScaffolder
implements Scaffolder {
    private final ApiGraphMapper graphMapper;
    private final TemplateEngine templateEngine;
    private static final Logger LOGGER = LoggerFactory.getLogger(APIKitScaffolder.class);

    public APIKitScaffolder(ApiGraphMapper graphMapper, TemplateEngine templateEngine) {
        this.graphMapper = graphMapper;
        this.templateEngine = templateEngine;
    }

    @Override
    public ScaffoldingResult scaffold(ScaffoldingConfig scaffoldingConfig) {
        try {
            Map<String, InputStream> result = this.getScaffoldingResult(scaffoldingConfig);
            Map<String, String> properties = this.templateEngine.generateProperties(scaffoldingConfig);
            return new ScaffoldingResultImpl(true, result, Collections.emptyList(), properties);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ScaffoldingResultImpl(false, Collections.emptyMap(), Collections.singletonList(new ScaffoldingErrorImpl(e.getCause(), "An error occurred while scaffolding")));
        }
    }

    @Override
    public ScaffoldingResult scaffoldMunitTestSuite(ScaffoldingConfig config) {
        try {
            Map<String, InputStream> result = this.getScaffoldingResult(config);
            return new ScaffoldingResultImpl(true, result, Collections.emptyList());
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ScaffoldingResultImpl(false, Collections.emptyMap(), Collections.singletonList(new ScaffoldingErrorImpl(e.getCause(), "An error occurred while scaffolding")));
        }
    }

    private Map<String, InputStream> getScaffoldingResult(ScaffoldingConfig scaffoldingConfig) throws IOException {
        String apiGraph = this.graphMapper.buildGraph(scaffoldingConfig.getApi());
        return this.templateEngine.execute(apiGraph, scaffoldingConfig);
    }
}

