/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.scaffolding.internal.template;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.mule.apikit.scaffolding.api.ScaffoldingConfig;
import org.mule.apikit.scaffolding.internal.template.TemplateEngine;
import org.mule.weave.v2.module.MimeType;
import org.mule.weave.v2.runtime.DataWeaveResult;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ScriptingBindings;

public class DataWeaveTemplateEngine
implements TemplateEngine {
    private static final String EMPTY_MULE_APP = "<core:mule xmlns:core=\"http://www.mulesoft.org/schema/mule/core\"/>";
    private static final String API_ID = "api";
    private static final String EXISTING_CONFIGURATION_ID = "existingConfiguration";
    private static final String CONFIGURATIONS_CONTENT_ID = "configsContent";
    private static final String API_PATH = "apiPath";
    private static final String PROPERTY_FILES = "propertyFiles";
    private final DataWeaveScriptingEngine dataWeaveScriptingEngine = new DataWeaveScriptingEngine();
    private final DataWeaveScript propertiesScript = this.dataWeaveScriptingEngine.compile(DataWeaveTemplateEngine.getResource("scripts/graphql/properties.dwl"), new String[]{"propertyFiles", "apiPath"});
    private final DataWeaveScript mergeScript = this.dataWeaveScriptingEngine.compile(DataWeaveTemplateEngine.getResource("scripts/mergeConfigs.dwl"), new String[]{"configsContent"});

    @Override
    public Map<String, InputStream> execute(String apiGraph, ScaffoldingConfig scaffoldingConfig) throws IOException {
        Map<String, InputStream> results = this.computeDifferenceUsingTemplateFiles(apiGraph, scaffoldingConfig);
        Map<String, InputStream> mergedResults = this.addDifferenceToExistingFiles(scaffoldingConfig, results);
        return mergedResults;
    }

    private Map<String, InputStream> computeDifferenceUsingTemplateFiles(String apiGraph, ScaffoldingConfig config) throws IOException {
        HashMap<String, InputStream> results = new HashMap<String, InputStream>();
        ScriptingBindings bindings = this.getBindings(config, apiGraph);
        for (Map.Entry<String, InputStream> template : config.getTemplates().entrySet()) {
            DataWeaveScript compiledScript = this.dataWeaveScriptingEngine.compile(IOUtils.toString((InputStream)template.getValue(), (Charset)StandardCharsets.UTF_8), bindings.bindingNames());
            DataWeaveResult result = compiledScript.write(bindings);
            results.put(template.getKey(), (InputStream)result.getContent());
        }
        return results;
    }

    private Map<String, InputStream> addDifferenceToExistingFiles(ScaffoldingConfig config, Map<String, InputStream> results) {
        Set<String> inputConfigs = config.getExistingConfigurations();
        HashMap<String, InputStream> mergedResults = new HashMap<String, InputStream>();
        for (Map.Entry<String, InputStream> entry : results.entrySet()) {
            String relativePath = entry.getKey();
            InputStream contents = entry.getValue();
            if (inputConfigs.contains(relativePath)) {
                InputStream originalContents = this.readProjectFile(config, relativePath);
                String mergedContents = this.unionConfigurations(Arrays.asList(originalContents, contents));
                contents = new ByteArrayInputStream(mergedContents.getBytes());
            }
            mergedResults.put(relativePath, contents);
        }
        return mergedResults;
    }

    private InputStream readProjectFile(ScaffoldingConfig config, String relativePath) {
        FileInputStream contents;
        String basePath = config.getBasePath();
        File file = Paths.get(basePath, relativePath).toFile();
        try {
            contents = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Configuration file does not exist " + file.getAbsolutePath(), e);
        }
        return contents;
    }

    @Override
    public Map<String, String> generateProperties(ScaffoldingConfig config) {
        List existingPropertyFiles = config.getExistingResources().stream().filter(v -> v.endsWith(".properties")).map(relativePath -> new Object((String)relativePath, config){
            public final String filename;
            public final InputStream contents;
            final /* synthetic */ String val$relativePath;
            final /* synthetic */ ScaffoldingConfig val$config;
            {
                this.val$relativePath = string;
                this.val$config = scaffoldingConfig;
                this.filename = this.val$relativePath;
                this.contents = DataWeaveTemplateEngine.this.readProjectFile(this.val$config, this.val$relativePath);
            }
        }).collect(Collectors.toList());
        ScriptingBindings bindings = new ScriptingBindings().addBinding(PROPERTY_FILES, existingPropertyFiles, "application/java").addBinding(API_PATH, (Object)config.getApi(), "text/plain");
        return (Map)this.propertiesScript.write(bindings).getContent();
    }

    private String unionConfigurations(List<InputStream> existingConfigs) {
        if (existingConfigs == null || existingConfigs.isEmpty()) {
            return EMPTY_MULE_APP;
        }
        ScriptingBindings bindings = new ScriptingBindings().addBinding(CONFIGURATIONS_CONTENT_ID, existingConfigs, "application/java");
        return this.mergeScript.write(bindings).getContentAsString();
    }

    private ScriptingBindings getBindings(ScaffoldingConfig config, String apiGraph) {
        ScriptingBindings scriptingBindings = new ScriptingBindings();
        scriptingBindings.addBinding(API_ID, (Object)apiGraph, MimeType.APPLICATION_JSON().toString());
        List<InputStream> muleXMLs = config.getExistingConfigurations().stream().map(relativePath -> this.readProjectFile(config, (String)relativePath)).collect(Collectors.toList());
        scriptingBindings.addBinding(EXISTING_CONFIGURATION_ID, (Object)this.unionConfigurations(muleXMLs), "application/xml");
        return scriptingBindings;
    }

    private static URL getResource(String name) {
        return DataWeaveTemplateEngine.class.getClassLoader().getResource(name);
    }
}

