%dw 2.0
import * from scripts::modules::ScaffoldingModule
import * from scripts::modules::PropertiesModule

ns core http://www.mulesoft.org/schema/mule/core
ns http http://www.mulesoft.org/schema/mule/http
ns graphqlrouter http://www.mulesoft.org/schema/mule/graphql-router

var graphqlNamespaces = {
    "xmlns:graphqlrouter": "http://www.mulesoft.org/schema/mule/graphql-router",
    "xmlns:http": "http://www.mulesoft.org/schema/mule/http"
}

var graphqlSchemaLocations = [
    "http://www.mulesoft.org/schema/mule/http http://www.mulesoft.org/schema/mule/http/current/mule-http.xsd",
    "http://www.mulesoft.org/schema/mule/graphql-router http://www.mulesoft.org/schema/mule/graphql-router/current/mule-graphql-router.xsd"
]

// Common configuration names referenced by several graphql script files
var listenerConfigName = "http-listener-config"
var routerConfigName = "api-router-config"
var mainFlowName = "api-main-flow"

/**
* Property specifications for GraphQL APIs
**/
fun getEnvironmentFile(apiPath) = [
  alwaysAddProperty("api.path", apiPath),
  addPropertyOnNewConfig("http.listener.path", "/graphql"),
  addPropertyOnNewConfig("http.listener.host", "0.0.0.0"),
  addPropertyOnNewConfig("http.listener.port", "8081"),
]

fun getDataFetcherFlow(operationName, objectTypeName, fieldName, example) = flow @("name": operationName) : {
   graphqlrouter#"data-fetcher" @("config-ref": routerConfigName, "objectTypeName": objectTypeName, "fieldName": fieldName): {},
   "set-payload" @("value": write(example, "application/json"), "mimeType": "application/json"): {},
   graphqlrouter#serialize @("config-ref": routerConfigName, "objectTypeName": objectTypeName, "fieldName": fieldName): {}
}

fun getDataFetcherLookupFunction(existingConfiguration, objectTypeName, fieldName) = lookupElementFromApp(
    existingConfiguration,
    (value, key, index) -> key ~= "flow" and
        value.graphqlrouter#"data-fetcher".@objectTypeName == objectTypeName and
        value.graphqlrouter#"data-fetcher".@fieldName == fieldName
)

fun scaffoldDataFetcherFlow(existingConfiguration, operationName, objectTypeName, fieldName, example) =
    scaffoldElement(
        getDataFetcherFlow(operationName, objectTypeName, fieldName, example),
        getDataFetcherLookupFunction(existingConfiguration, objectTypeName, fieldName)
    )
