%dw 2.0
input api application/json
input existingConfiguration application/xml
output application/xml
import every,firstWith from dw::core::Arrays
import toBoolean from dw::util::Coercions
import * from scripts::modules::ScaffoldingModule
import * from scripts::graphql::GraphqlModule
import * from scripts::modules::SharedComponentsModule
---
mule @((getMuleNamespaces(graphqlNamespaces,graphqlSchemaLocations))): {
    (
        scaffoldElement(
            (http#"listener-config" @("name": listenerConfigName): {
                 http#"listener-connection" @("host": "\${http.listener.host}", "port": "\${http.listener.port}"): {}
             }),
            lookupElementFromApp(
                existingConfiguration,
                (value, key, index) -> key ~= "listener-config" and value.@name == listenerConfigName
            )
         )
    ),
    (
        scaffoldElement(
            (graphqlrouter#config @("name": routerConfigName, "api": "\${api.path}"): {}),
            lookupElementFromApp(
                existingConfiguration,
                (value, key, index) -> key ~= "config" and value.@name == routerConfigName
            )
        )
    ),
    (
        scaffoldGlobalConfigurationProperties(existingConfiguration)
    ),
    (
        scaffoldGlobalProperties(existingConfiguration)
    )
}