/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.scaffolding.internal;

import java.io.InputStream;
import java.util.Map;

public class ScaffoldingInternalResult {

  private final Map<String, InputStream> muleXmls;
  private final Map<String, String> properties;

  public ScaffoldingInternalResult(Map<String, InputStream> muleXmls, Map<String, String> properties) {
    this.muleXmls = muleXmls;
    this.properties = properties;
  }

  public Map<String, InputStream> getMuleXmls() {
    return muleXmls;
  }

  public Map<String, String> getProperties() {
    return properties;
  }
}
