%dw 2.0
input api application/json
output application/xml defaultNamespace="http://www.mulesoft.org/schema/mule/core"
import * from scripts::modules::ApiGraphModule
import * from scripts::modules::ScaffoldingModule
import * from scripts::modules::GeneratingQueriesModule
import * from scripts::graphql::GraphqlModule
import getMuleNamespaces from scripts::modules::SharedComponentsModule
import every,firstWith from dw::core::Arrays
import toBoolean from dw::util::Coercions
import * from dw::core::Arrays

ns munit http://www.mulesoft.org/schema/mule/munit
var tools = {
    prefix: "munit-tools",
    uri: "http://www.mulesoft.org/schema/mule/munit-tools"
} as Namespace

var flows =
    getNodeShapeTypes(api)
    flatMap (schema) ->
        getPropertiesFromSchema(api, schema)
        flatMap (property) ->
            getNotScalarPropertyTypes(api, property)
            flatMap getNodeShapeFromCompoundShape(api, $)
            filter !isEmpty($)
            flatMap "$(schema.'shacl:name').$(property.'shacl:name')"

fun munitTest(operationName) = munit#test @("name":joinBy([operationName,"Test"],"")):{
    munit#"enable-flow-sources" :{
        munit#"enable-flow-source" @(value: mainFlowName):{},
        (getOperationsNames(api) map ((operationName) ->
        munit#"enable-flow-source" @(value : operationName):{})),
        (flows map ((operationName) ->
        munit#"enable-flow-source" @(value : operationName):{})),
    },
    munit#execution: {
        http#request @(method : "POST", "config-ref":"HTTP_Request_configuration", path:"/graphql"):{
        http#body:
        getQueryByOperationName(operationName,api),
        http#headers :
            "#[{ 'Content-Type': 'application/json' }]"
        }},
    munit#validation: {
        tools#"assert-that" @(message: "The HTTP Status code is not correct!", expression:"#[attributes.statusCode]", "is":"#[MunitTools::equalTo(200)]"):{},
        tools#"assert-that" @(message: "The response payload is not correct!", expression:"#[payload]", "is":"#[MunitTools::notNullValue()]"):{}
    }
}

var munitNamespacesLocations =
    graphqlSchemaLocations ++
    [
        "http://www.mulesoft.org/schema/mule/munit http://www.mulesoft.org/schema/mule/munit/current/mule-munit.xsd",
        "http://www.mulesoft.org/schema/mule/munit-tools  http://www.mulesoft.org/schema/mule/munit-tools/current/mule-munit-tools.xsd"
    ]
---
mule @((getMuleNamespaces(munitNamespacesLocations))):
    {
        (munit#config @(name:"graphql-test-suite.xml"):{}),
        (http#"request-config" @(name:"HTTP_Request_configuration"):{
            http#"request-connection" @(host:"localhost", port:"8081"):{}}),
        (
        getOperationsNames(api) map ((operationName) -> 
                scaffoldElement(
                munitTest(operationName),
            []
    )))
       
}
