%dw 2.0
import * from scripts::modules::ScaffoldingModule

var sharedSchemaLocations = [
    "http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd",
]

fun scaffoldGlobalConfigurationProperties(existingConfiguration) =
    scaffoldElement(
        ("configuration-properties" @("file": "\${env}-properties.properties"): {}),
        lookupElementFromApp(
            existingConfiguration,
            (value, key, index) -> key ~= "configuration-properties" and value.@file == "\${env}-properties.properties"
        )
    )

fun scaffoldGlobalProperties(existingConfiguration) =
    scaffoldElement(
        ("global-property" @("name": "env", "value": "dev"): {}),
        lookupElementFromApp(
            existingConfiguration,
            (value, key, index) -> key ~= "global-property" and value.@name == "env" and value.@value == "dev"
        )
    )

fun getMuleNamespaces(schemaLocationsToInclude: Array<String>) = {
  xsi#schemaLocation: (sharedSchemaLocations ++ schemaLocationsToInclude) joinBy " "
}

