/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.scaffolding.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.mule.apikit.scaffolding.api.Scaffolder;
import org.mule.apikit.scaffolding.api.ScaffoldingConfig;
import org.mule.apikit.scaffolding.api.ScaffoldingResult;
import org.mule.apikit.scaffolding.internal.ScaffoldingErrorImpl;
import org.mule.apikit.scaffolding.internal.ScaffoldingInternalResult;
import org.mule.apikit.scaffolding.internal.ScaffoldingResultImpl;
import org.mule.apikit.scaffolding.internal.mapper.ApiGraphMapper;
import org.mule.apikit.scaffolding.internal.mapper.ApiGraphResult;
import org.mule.apikit.scaffolding.internal.template.TemplateEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIKitScaffolder
implements Scaffolder {
    private final ApiGraphMapper graphMapper;
    private final TemplateEngine templateEngine;
    private static final Logger LOGGER = LoggerFactory.getLogger(APIKitScaffolder.class);

    public APIKitScaffolder(ApiGraphMapper graphMapper, TemplateEngine templateEngine) {
        this.graphMapper = graphMapper;
        this.templateEngine = templateEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScaffoldingResult scaffold(ScaffoldingConfig scaffoldingConfig) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(APIKitScaffolder.class.getClassLoader());
            ScaffoldingInternalResult result = this.getScaffoldingResult(scaffoldingConfig);
            ScaffoldingResultImpl scaffoldingResultImpl = new ScaffoldingResultImpl(true, result.getMuleXmls(), Collections.emptyList(), result.getProperties());
            return scaffoldingResultImpl;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ScaffoldingResultImpl scaffoldingResultImpl = new ScaffoldingResultImpl(false, Collections.emptyMap(), Collections.singletonList(new ScaffoldingErrorImpl(e.getCause(), "An error occurred while scaffolding")));
            return scaffoldingResultImpl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScaffoldingResult scaffoldMunitTestSuite(ScaffoldingConfig config) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(APIKitScaffolder.class.getClassLoader());
            ScaffoldingInternalResult result = this.getScaffoldingResult(config);
            ScaffoldingResultImpl scaffoldingResultImpl = new ScaffoldingResultImpl(true, result.getMuleXmls(), Collections.emptyList());
            return scaffoldingResultImpl;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ScaffoldingResultImpl scaffoldingResultImpl = new ScaffoldingResultImpl(false, Collections.emptyMap(), Collections.singletonList(new ScaffoldingErrorImpl(e.getCause(), "An error occurred while scaffolding Munit Test Suite")));
            return scaffoldingResultImpl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    private ScaffoldingInternalResult getScaffoldingResult(ScaffoldingConfig scaffoldingConfig) throws IOException {
        ApiGraphResult apiGraphResult = this.graphMapper.buildGraph(scaffoldingConfig.getApi());
        Map<String, InputStream> muleXmls = this.templateEngine.execute(apiGraphResult, scaffoldingConfig);
        Map<String, String> properties = this.templateEngine.generateProperties(apiGraphResult, scaffoldingConfig);
        return new ScaffoldingInternalResult(muleXmls, properties);
    }
}

