%dw 2.0
import * from scripts::asyncapi::AsyncApiModule

input api application/json
input existingConfiguration application/xml
output application/xml defaultNamespace="http://www.mulesoft.org/schema/mule/core"

var serverProtocol = getServerProtocolName(api)
---
mule @((getMuleNamespacesByApi(api))): {
    (
        getSubscribeOperations(api) map ((subscribeOp, index) ->
            do {
                var flowName = "SUBSCRIBE:" ++ replaceInvalidCharacters(subscribeOp.channel)
                ---
                scaffoldSubscribeFlow(serverProtocol,existingConfiguration,flowName,subscribeOp)
            }

        )
    ),
    (
        getPublishOperations(api) map ((publishOp, index) ->
            do {
                var curatedChannelName = replaceInvalidCharacters(publishOp.channel)
                var flowName = "PUBLISH:" ++ curatedChannelName
                ---
                scaffoldPublishFlow(serverProtocol,existingConfiguration,flowName, curatedChannelName, publishOp)
            }
        )
    )
}
