%dw 2.0
input api application/json
input existingConfiguration application/xml
output application/xml defaultNamespace="http://www.mulesoft.org/schema/mule/core"
import * from scripts::modules::ApiGraphModule
import * from scripts::modules::ScaffoldingModule
import * from scripts::graphql::GraphqlModule
import getMuleNamespaces from scripts::modules::SharedComponentsModule
import getExample from scripts::graphql::ExampleGeneration
import every,firstWith from dw::core::Arrays
import toBoolean from dw::util::Coercions
---
mule @((getMuleNamespaces(graphqlSchemaLocations))): {
    (
        scaffoldElement(
            (flow @("name": mainFlowName): {
                 http#listener @("config-ref": listenerConfigName, path: "\${http.listener.path}"): {},
                 graphqlrouter#route @("config-ref": routerConfigName): {}
            }),
            lookupElementFromApp(
                existingConfiguration,
                (value, key, index) -> key ~= "flow" and value.@name == mainFlowName
            )
        )
    ),
    (
        getOperations(api) map ((operation) ->
            do {
                var name = operation."apiContract:operationId"
                var splitOperationName = name splitBy  "."
                var objectTypeName = splitOperationName[0] default ""
                var fieldName = splitOperationName[1] default ""
                var fieldShapeID = getSchemaShapeID(api, operation)
                ---
                scaffoldDataFetcherFlow(existingConfiguration, name, objectTypeName, fieldName, getExample(api, fieldShapeID))
            }
        )
    ),
    (
        getNodeShapeTypes(api) flatMap ((schema, index) ->
            getPropertiesFromSchema(api,schema)
                flatMap ((property, index) ->
                    getNotScalarPropertyTypes(api,property)
                        flatMap ((compoundShape, index) ->
                            getNodeShapeFromCompoundShape(api,compoundShape)
                        )
                filter ((item, index) -> !isEmpty(item))
                flatMap ((nodeShape, index) ->
                    do {
                        var objectTypeName = schema."shacl:name"
                        var fieldName = property."shacl:name"
                        var fieldShapeID = property."raml-shapes:range"."@id"
                        var operationName = "$(objectTypeName).$(fieldName)"
                        ---
                        scaffoldDataFetcherFlow(existingConfiguration, operationName, objectTypeName, fieldName, getExample(api, fieldShapeID))
                    }
                )
            )
        )
    ),
}
