%dw 2.0
input api application/json
input configsContent application/java
input specification text/plain
output application/xml defaultNamespace="http://www.mulesoft.org/schema/mule/core"
import getMuleNamespaces from scripts::modules::SharedComponentsModule
import * from scripts::graphql::GraphqlModule
import * from scripts::asyncapi::AsyncApiModule

var content = configsContent map read($,"application/xml").mule filter $ != null

var namespaces =
    specification match {
        case spec if (spec == "GraphQL") ->
            getMuleNamespaces(scripts::graphql::GraphqlModule::graphqlSchemaLocations)
        case spec if (spec == "ASYNC 2.0") ->
            scripts::asyncapi::AsyncApiModule::getMuleNamespacesByApi(api)
        else -> {}
    }
---
mule @((namespaces)) :
{
   (content)
}
