/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.scaffolding.internal.template;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.LineSeparator;
import org.jdom2.output.XMLOutputter;
import org.mule.apikit.scaffolding.api.ScaffoldingConfig;
import org.mule.apikit.scaffolding.internal.error.TemplateEngineError;
import org.mule.apikit.scaffolding.internal.mapper.ApiGraphResult;
import org.mule.apikit.scaffolding.internal.template.TemplateEngine;
import org.mule.weave.v2.core.exception.UserException;
import org.mule.weave.v2.runtime.DataWeaveResult;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ScriptingBindings;

public class DataWeaveTemplateEngine
implements TemplateEngine {
    private static final String EMPTY_MULE_APP = "<core:mule xmlns:core=\"http://www.mulesoft.org/schema/mule/core\"/>";
    private static final String API_ID = "api";
    private static final String SPEC_ID = "specification";
    private static final String EXISTING_CONFIGURATION_ID = "existingConfiguration";
    private static final String CONFIGURATIONS_CONTENT_ID = "configsContent";
    private static final String API_PATH = "apiPath";
    private static final String PROPERTY_FILES = "propertyFiles";
    private final DataWeaveScriptingEngine dataWeaveScriptingEngine = new DataWeaveScriptingEngine();
    private final DataWeaveScript propertiesScript = this.dataWeaveScriptingEngine.compile(DataWeaveTemplateEngine.getResource("scripts/properties.dwl"), new String[]{"propertyFiles", "apiPath", "api"});
    private final DataWeaveScript mergeScript = this.dataWeaveScriptingEngine.compile(DataWeaveTemplateEngine.getResource("scripts/mergeConfigs.dwl"), new String[]{"configsContent"});
    private final DataWeaveScript protocolsScript = this.dataWeaveScriptingEngine.compile(DataWeaveTemplateEngine.getResource("scripts/dependencies.dwl"), new String[]{"api", "apiPath"});

    @Override
    public Map<String, InputStream> execute(ApiGraphResult apiGraphResult, ScaffoldingConfig scaffoldingConfig) throws TemplateEngineError {
        try {
            Map<String, InputStream> results = this.computeDifferenceUsingTemplateFiles(apiGraphResult, scaffoldingConfig);
            Map<String, InputStream> mergedResults = this.addDifferenceToExistingFiles(apiGraphResult, scaffoldingConfig, results);
            Map<String, InputStream> namespaceCorrectedResults = this.fixupNamespaces(mergedResults);
            return namespaceCorrectedResults;
        }
        catch (IOException | UserException e) {
            if (e instanceof UserException) {
                throw new TemplateEngineError((UserException)e);
            }
            throw new TemplateEngineError(e);
        }
    }

    private Map<String, InputStream> fixupNamespaces(Map<String, InputStream> mergedResults) throws IOException {
        HashMap<String, InputStream> result = new HashMap<String, InputStream>();
        for (Map.Entry<String, InputStream> entry : mergedResults.entrySet()) {
            String filename = entry.getKey();
            InputStream contents = entry.getValue();
            try {
                Document document = new SAXBuilder().build(contents);
                Element root = document.getRootElement();
                this.addNamespaces(root, root);
                Format format = Format.getPrettyFormat().setLineSeparator(LineSeparator.NL);
                String output = new XMLOutputter(format).outputString(document);
                result.put(filename, new ByteArrayInputStream(output.getBytes(StandardCharsets.UTF_8)));
            }
            catch (JDOMException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private void addNamespaces(Element from, Element to) {
        Namespace ns = from.getNamespace();
        if (!ns.getPrefix().isEmpty()) {
            to.addNamespaceDeclaration(ns);
        }
        from.getChildren().forEach(elem -> this.addNamespaces((Element)elem, to));
    }

    private Map<String, InputStream> computeDifferenceUsingTemplateFiles(ApiGraphResult apiGraphResult, ScaffoldingConfig config) throws IOException, UserException {
        HashMap<String, InputStream> results = new HashMap<String, InputStream>();
        ScriptingBindings bindings = this.getBindings(config, apiGraphResult);
        for (Map.Entry<String, InputStream> template : config.getTemplates().entrySet()) {
            DataWeaveScript compiledScript = this.dataWeaveScriptingEngine.compile(IOUtils.toString((InputStream)template.getValue(), (Charset)StandardCharsets.UTF_8), bindings.bindingNames());
            DataWeaveResult result = compiledScript.write(bindings);
            results.put(template.getKey(), (InputStream)result.getContent());
        }
        return results;
    }

    private Map<String, InputStream> addDifferenceToExistingFiles(ApiGraphResult apiGraphResult, ScaffoldingConfig config, Map<String, InputStream> results) {
        Set<String> inputConfigs = config.getExistingConfigurations();
        HashMap<String, InputStream> mergedResults = new HashMap<String, InputStream>();
        for (Map.Entry<String, InputStream> entry : results.entrySet()) {
            String relativePath = entry.getKey();
            InputStream contents = entry.getValue();
            if (inputConfigs.contains(relativePath)) {
                InputStream originalContents = this.readProjectFile(config, relativePath);
                String mergedContents = this.unionConfigurations(Arrays.asList(contents, originalContents), apiGraphResult);
                contents = new ByteArrayInputStream(mergedContents.getBytes());
            }
            mergedResults.put(relativePath, contents);
        }
        return mergedResults;
    }

    private InputStream readProjectFile(ScaffoldingConfig config, String relativePath) {
        FileInputStream contents;
        String basePath = config.getBasePath();
        File file = Paths.get(basePath, relativePath).toFile();
        try {
            contents = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Configuration file does not exist " + file.getAbsolutePath(), e);
        }
        return contents;
    }

    @Override
    public Map<String, String> generateProperties(ApiGraphResult apiGraphResult, ScaffoldingConfig config) {
        List existingPropertyFiles = config.getExistingResources().stream().filter(v -> v.endsWith(".properties")).map(relativePath -> new Object((String)relativePath, config){
            public final String filename;
            public final InputStream contents;
            final /* synthetic */ String val$relativePath;
            final /* synthetic */ ScaffoldingConfig val$config;
            {
                this.val$relativePath = string;
                this.val$config = scaffoldingConfig;
                this.filename = this.val$relativePath;
                this.contents = DataWeaveTemplateEngine.this.readProjectFile(this.val$config, this.val$relativePath);
            }
        }).collect(Collectors.toList());
        ScriptingBindings bindings = new ScriptingBindings().addBinding(PROPERTY_FILES, existingPropertyFiles, "application/java").addBinding(API_PATH, (Object)config.getApi(), "text/plain").addBinding(API_ID, (Object)apiGraphResult.getGraphApi(), "application/json");
        return (Map)this.propertiesScript.write(bindings).getContent();
    }

    @Override
    public List<String> getDependencies(ApiGraphResult apiGraphResult, ScaffoldingConfig scaffoldingConfig) {
        ScriptingBindings bindings = new ScriptingBindings().addBinding(API_ID, (Object)apiGraphResult.getGraphApi(), "application/json").addBinding(API_PATH, (Object)scaffoldingConfig.getApi(), "text/plain");
        return (List)this.protocolsScript.write(bindings).getContent();
    }

    private String unionConfigurations(List<InputStream> existingConfigs, ApiGraphResult apiGraphResult) {
        if (existingConfigs == null || existingConfigs.isEmpty()) {
            return EMPTY_MULE_APP;
        }
        ScriptingBindings bindings = new ScriptingBindings().addBinding(API_ID, (Object)apiGraphResult.getGraphApi(), "application/json").addBinding(CONFIGURATIONS_CONTENT_ID, existingConfigs, "application/java").addBinding(SPEC_ID, (Object)apiGraphResult.getSpecification(), "text/plain");
        return this.mergeScript.write(bindings).getContentAsString();
    }

    private ScriptingBindings getBindings(ScaffoldingConfig config, ApiGraphResult apiGraphResult) {
        ScriptingBindings scriptingBindings = new ScriptingBindings();
        scriptingBindings.addBinding(API_ID, (Object)apiGraphResult.getGraphApi(), "application/json");
        List<InputStream> muleXMLs = config.getExistingConfigurations().stream().map(relativePath -> this.readProjectFile(config, (String)relativePath)).collect(Collectors.toList());
        scriptingBindings.addBinding(EXISTING_CONFIGURATION_ID, (Object)this.unionConfigurations(muleXMLs, apiGraphResult), "application/xml");
        return scriptingBindings;
    }

    private static URL getResource(String name) {
        return DataWeaveTemplateEngine.class.getClassLoader().getResource(name);
    }
}

