/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.scaffolding.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.apikit.scaffolding.api.ScaffoldingDependency;
import org.mule.apikit.scaffolding.api.ScaffoldingError;
import org.mule.apikit.scaffolding.api.ScaffoldingResult;

public class ScaffoldingResultImpl
implements ScaffoldingResult {
    private final boolean success;
    private final Map<String, InputStream> xmls;
    private final Map<String, String> propertiesFiles;
    private final List<ScaffoldingError> errors;
    private final List<ScaffoldingDependency> dependencies;

    public ScaffoldingResultImpl(boolean success, Map<String, InputStream> xmls, List<ScaffoldingError> errors) {
        this(success, xmls, errors, new HashMap<String, String>(), new ArrayList<ScaffoldingDependency>());
    }

    public ScaffoldingResultImpl(boolean success, Map<String, InputStream> xmls, List<ScaffoldingError> errors, Map<String, String> propertiesFiles, List<ScaffoldingDependency> dependencies) {
        this.success = success;
        this.xmls = xmls;
        this.errors = errors;
        this.propertiesFiles = propertiesFiles;
        this.dependencies = dependencies;
    }

    @Override
    public boolean success() {
        return this.success;
    }

    @Override
    public Map<String, InputStream> generatedMuleXmls() {
        return this.xmls;
    }

    @Override
    public Map<String, InputStream> generatedPropertiesFiles() {
        HashMap<String, InputStream> result = new HashMap<String, InputStream>();
        this.propertiesFiles.forEach((key, value) -> {
            InputStream cfr_ignored_0 = result.put((String)key, new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8)));
        });
        return result;
    }

    @Override
    public List<ScaffoldingError> errors() {
        return this.errors;
    }

    @Override
    public List<ScaffoldingDependency> dependencies() {
        return this.dependencies;
    }
}

