/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.scaffolding.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.apikit.scaffolding.api.Scaffolder;
import org.mule.apikit.scaffolding.api.ScaffoldingConfig;
import org.mule.apikit.scaffolding.api.ScaffoldingDependency;
import org.mule.apikit.scaffolding.api.ScaffoldingResult;
import org.mule.apikit.scaffolding.internal.ScaffoldingDependencyImpl;
import org.mule.apikit.scaffolding.internal.ScaffoldingErrorImpl;
import org.mule.apikit.scaffolding.internal.ScaffoldingInternalResult;
import org.mule.apikit.scaffolding.internal.ScaffoldingResultImpl;
import org.mule.apikit.scaffolding.internal.error.TemplateEngineError;
import org.mule.apikit.scaffolding.internal.mapper.ApiGraphMapper;
import org.mule.apikit.scaffolding.internal.mapper.ApiGraphResult;
import org.mule.apikit.scaffolding.internal.property.ApplicationProperties;
import org.mule.apikit.scaffolding.internal.property.domain.ProtocolProperty;
import org.mule.apikit.scaffolding.internal.template.TemplateEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIKitScaffolder
implements Scaffolder {
    private final ApiGraphMapper graphMapper;
    private final TemplateEngine templateEngine;
    private static final Logger LOGGER = LoggerFactory.getLogger(APIKitScaffolder.class);

    public APIKitScaffolder(ApiGraphMapper graphMapper, TemplateEngine templateEngine) {
        this.graphMapper = graphMapper;
        this.templateEngine = templateEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScaffoldingResult scaffold(ScaffoldingConfig scaffoldingConfig) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(APIKitScaffolder.class.getClassLoader());
            ScaffoldingInternalResult result = this.getScaffoldingResult(scaffoldingConfig);
            ScaffoldingResultImpl scaffoldingResultImpl = new ScaffoldingResultImpl(true, result.getMuleXmls(), Collections.emptyList(), result.getProperties(), this.getDependencyGAVs(result.getDependencies()), result.getAdditionalInformation());
            return scaffoldingResultImpl;
        }
        catch (IOException | TemplateEngineError e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ScaffoldingResultImpl scaffoldingResultImpl = new ScaffoldingResultImpl(false, Collections.emptyMap(), Collections.singletonList(new ScaffoldingErrorImpl(e.getCause(), e.getMessage())));
            return scaffoldingResultImpl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScaffoldingResult scaffoldMunitTestSuite(ScaffoldingConfig config) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(APIKitScaffolder.class.getClassLoader());
            ScaffoldingInternalResult result = this.getScaffoldingResult(config);
            ScaffoldingResultImpl scaffoldingResultImpl = new ScaffoldingResultImpl(true, result.getMuleXmls(), Collections.emptyList());
            return scaffoldingResultImpl;
        }
        catch (IOException | TemplateEngineError e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ScaffoldingResultImpl scaffoldingResultImpl = new ScaffoldingResultImpl(false, Collections.emptyMap(), Collections.singletonList(new ScaffoldingErrorImpl(e.getCause(), "An error occurred while scaffolding Munit Test Suite")));
            return scaffoldingResultImpl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    private ScaffoldingInternalResult getScaffoldingResult(ScaffoldingConfig scaffoldingConfig) throws IOException, TemplateEngineError {
        ApiGraphResult apiGraphResult = this.graphMapper.buildGraph(scaffoldingConfig.getApi());
        Map<String, InputStream> muleXmls = this.templateEngine.execute(apiGraphResult, scaffoldingConfig);
        Map<String, String> properties = this.templateEngine.generateProperties(apiGraphResult, scaffoldingConfig);
        List<String> dependencies = this.templateEngine.getDependencies(apiGraphResult, scaffoldingConfig);
        Map<String, List<String>> additionalInformation = this.templateEngine.getAdditionalInformation(apiGraphResult, scaffoldingConfig);
        return new ScaffoldingInternalResult(muleXmls, properties, dependencies, additionalInformation);
    }

    private List<ScaffoldingDependency> getDependencyGAVs(List<String> dependencies) throws IOException {
        Map<String, ProtocolProperty> protocols = ApplicationProperties.getProperties().getAsyncapi().getProtocols();
        return dependencies.stream().map(dependency -> {
            ProtocolProperty property = (ProtocolProperty)protocols.get(dependency);
            return new ScaffoldingDependencyImpl(property.toGav(), property.getClassifier());
        }).collect(Collectors.toList());
    }
}

