/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.scaffolding.api;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

public interface ScaffoldingResult {

  /**
   * Check if the scaffolding process was successful
   */
  boolean success();

  /**
   * @return Map<fileName, Content> with fileNames and Contents as InputStream
   */
  Map<String, InputStream> generatedMuleXmls();

  /**
   * @return Map<fileName, Content> with fileNames and Contents as InputStream
   */
  Map<String, InputStream> generatedPropertiesFiles();

  /**
   * @return List of errors in case scaffolding was not success, otherwise emptyList
   */
  List<ScaffoldingError> errors();

  /**
   * @return List of module/connector dependencies (only applies to asyncapi, otherwise empty)
   */
  List<ScaffoldingDependency> dependencies();

  /**
   * @return Map of additional information used for metrics evaluation to indicate that an API Specification contains a certain
   *         element type or conditions which are not provided by Exchange or is required at scaffolding time. Note: It is always
   *         recommended to use Exchange information if available for metrics for data consistency, this information is only meant
   *         for scenarios where this data does not exist or won't be included in Exchange.
   */
  Map<String, List<String>> additionalInformation();

}
