/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.scaffolding.internal.template;

import org.mule.apikit.scaffolding.api.ScaffoldingConfig;
import org.mule.apikit.scaffolding.internal.error.TemplateEngineError;
import org.mule.apikit.scaffolding.internal.mapper.ApiGraphResult;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public interface TemplateEngine {

  /**
   * Executes the template engine
   *
   * @param apiGraphResult api as a JSON-LD graph
   * @param scaffoldingConfig scaffolding configuration
   * @return resulting files
   * @throws IOException
   */
  Map<String, InputStream> execute(ApiGraphResult apiGraphResult, ScaffoldingConfig scaffoldingConfig) throws TemplateEngineError;


  Map<String, String> generateProperties(ApiGraphResult apiGraphResult, ScaffoldingConfig scaffoldingConfig);

  List<String> getDependencies(ApiGraphResult apiGraphResult, ScaffoldingConfig scaffoldingConfig);

  Map<String, List<String>> getAdditionalInformation(ApiGraphResult apiGraphResult, ScaffoldingConfig scaffoldingConfig);

  List<String> getApiFragments(String exchangeJson);
}
