/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.scaffolding.internal.mapper;

import amf.core.client.common.remote.Content;
import amf.core.client.platform.resource.ResourceLoader;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class APISyncResourceLoader
implements ResourceLoader {
    private String rootResource;
    private static final String EXCHANGE_MODULES = "exchange_modules";
    private static final Pattern EXCHANGE_PATTERN = Pattern.compile("exchange_modules/([^/]+)/([^/]+)/([^/]+)/(.*)");
    private static final String RESOURCE_FORMAT = "resource::%s:%s:%s:%s:%s:%s";
    private static final String RAML_FRAGMENT_CLASSIFIER = "raml-fragment";
    private static final String EXCHANGE_TYPE = "zip";
    private static final String protocol = "jar:file:";
    private static final String localRepository = System.getProperty("user.home").replaceAll("\\\\", "/") + "/.m2/repository";
    private static final String API_SYNC_PROTOCOL = "resource::";

    public APISyncResourceLoader(String mainFile) {
        this.rootResource = mainFile.substring(0, mainFile.lastIndexOf(":") + 1);
    }

    public CompletableFuture<Content> fetch(String resource) {
        CompletableFuture<Content> result = new CompletableFuture<Content>();
        try {
            if (resource == null) {
                result.completeExceptionally(new RuntimeException("Cannot resolve resource null"));
                return result;
            }
            URI resourceURI = this.apiSyncToURI(this.toApiSyncResource(resource));
            URLConnection connection = resourceURI.toURL().openConnection();
            connection.setUseCaches(false);
            String fileContent = IOUtils.toString((InputStream)connection.getInputStream());
            result.complete(new Content(fileContent, resource));
            return result;
        }
        catch (Exception e) {
            result.completeExceptionally(e);
            return result;
        }
    }

    private String toApiSyncResource(String resource) {
        if (this.isAPISync(resource)) {
            return resource;
        }
        if (this.isExchangeModules(resource)) {
            return this.exchangeModuleToAPISync(resource);
        }
        return this.rootResource + resource;
    }

    private boolean isExchangeModules(String path) {
        return EXCHANGE_PATTERN.matcher(path).find();
    }

    private boolean isAPISync(String path) {
        return path.startsWith(API_SYNC_PROTOCOL);
    }

    private String exchangeModuleToAPISync(String resource) {
        String resourceToFetch = resource.substring(resource.lastIndexOf(EXCHANGE_MODULES));
        Matcher exchangeMatcher = EXCHANGE_PATTERN.matcher(resourceToFetch);
        if (!exchangeMatcher.find()) {
            return resource;
        }
        String groupId = exchangeMatcher.group(1);
        String artifactId = exchangeMatcher.group(2);
        String version = exchangeMatcher.group(3);
        String filePath = exchangeMatcher.group(4);
        return String.format(RESOURCE_FORMAT, groupId, artifactId, version, RAML_FRAGMENT_CLASSIFIER, EXCHANGE_TYPE, filePath);
    }

    private URI apiSyncToURI(String apiSync) throws URISyntaxException {
        String[] parts = apiSync.substring(API_SYNC_PROTOCOL.length()).split(":");
        String groupId = parts[0].replaceAll("\\.", "/");
        String artifact = parts[1];
        String version = parts[2];
        String classifier = parts[3];
        String file = parts[5];
        return new URI(String.format("%s%s/%s/%s/%s/%s-%s-%s.zip!/%s", protocol, this.getLocalRepository(), groupId, artifact, version, artifact, version, classifier, file));
    }

    protected String getLocalRepository() {
        return localRepository;
    }
}

