/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.scaffolding.internal.mapper;

import amf.apicontract.client.platform.AMFBaseUnitClient;
import amf.apicontract.client.platform.AMFConfiguration;
import amf.core.client.platform.AMFParseResult;
import amf.core.client.platform.AMFResult;
import amf.core.client.platform.config.RenderOptions;
import amf.core.client.platform.model.document.BaseUnit;
import amf.core.internal.remote.Spec;
import org.mulesoft.common.io.Output;
import org.yaml.builder.JsonOutputBuilder;

import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.ExecutionException;

import static amf.core.client.common.transform.PipelineId.Editing;

/**
 * Parses the API spec and returns the JSON-LD representation
 */
public abstract class AmfApiGraphMapper implements ApiGraphMapper {

  @Override
  public ApiGraphResult buildGraph(String api) {
    try {
      AMFParseResult parseResult = getClient(api).parse(api).get();
      BaseUnit model = parseResult.baseUnit();
      Spec spec = parseResult.sourceSpec();
      RenderOptions renderOptions = new RenderOptions().withAmfJsonLdSerialization().withoutSourceMaps()
          .withoutPrettyPrint().withCompactUris();
      // TODO: Remove this if at any time GraphQL is supported by
      // APIConfiguration#fromSpec
      AMFConfiguration amfConfiguration = getConfiguration(spec).withRenderOptions(renderOptions);

      AMFResult transformResult = amfConfiguration.baseUnitClient().transform(model, Editing());

      Writer writer = new StringWriter();
      JsonOutputBuilder<Writer> jsonBuilder = JsonOutputBuilder.apply(writer, false, Output.outputWriter());
      amfConfiguration.baseUnitClient().renderGraphToBuilder(transformResult.baseUnit(), jsonBuilder);

      return new ApiGraphResult(spec.id(), writer.toString());
    } catch (InterruptedException | ExecutionException e) {
      throw new RuntimeException(e);
    }
  }

  protected abstract AMFBaseUnitClient getClient(String api);

  protected abstract AMFConfiguration getConfiguration(Spec spec);

}
