/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.scaffolding.internal.property;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import org.mule.apikit.scaffolding.internal.property.domain.ApplicationProperty;

import java.io.IOException;
import java.io.InputStream;

/**
 * @author Berkay Polat
 * @since Mar 18, 2024
 */
public class ApplicationProperties {

  private ApplicationProperties() {}

  public static ApplicationProperty getProperties() throws IOException {
    String propFileName = "application.yaml";
    try (InputStream inputStream =
        ApplicationProperties.class.getClassLoader().getResourceAsStream(propFileName)) {
      ObjectMapper objectMapper = new ObjectMapper(new YAMLFactory());
      return objectMapper.readValue(inputStream, ApplicationProperty.class);
    }
  }
}
