%dw 2.0
import * from scripts::asyncapi::AsyncApiModule
import getSchemaLocations from scripts::asyncapi::protocol::ProtocolAdapterModule

input api application/json
input existingConfiguration application/xml
output application/xml defaultNamespace="http://www.mulesoft.org/schema/mule/core"

var protocols = getServerProtocols(api)
var schemas = [getAsyncApiSchemaLocation()] ++ getSchemaLocations(protocols)
var publishOps = getPublishOpTypes(api)
var serverNames: Array<String> = getServers(api) map $."core:name"
---
mule @((getMuleNamespacesByProtocolSchemas(schemas))): {
    (
        publishOps map ((publishOp, index) ->
            scaffoldAsyncApiSubscribeFlows(api, existingConfiguration, serverNames, publishOp)
        )
    )
}
