%dw 2.0
import scaffoldGlobalProperties, scaffoldGlobalConfigurationProperties from scripts::modules::SharedComponentsModule
import * from scripts::asyncapi::protocol::ProtocolAdapterModule
import * from scripts::asyncapi::AsyncApiModule
import * from scripts::modules::ScaffoldingModule

input api application/json
input existingConfiguration application/xml
output application/xml defaultNamespace="http://www.mulesoft.org/schema/mule/core"

var protocols = getServerProtocols(api)
var schemas =  [getAsyncApiSchemaLocation()] ++ getSchemaLocations(protocols)
---
mule @((getMuleNamespacesByProtocolSchemas(schemas))): {
    (
        scaffoldProtocolConfigs(api, protocols, existingConfiguration)
    ),
    (
        scaffoldGlobalConfigurationProperties(existingConfiguration)
    ),
    (
        scaffoldGlobalProperties(existingConfiguration)
    ),
    (
        scaffoldElement(
            apikitEda#"config" @("name": asyncApiConfigName, "apiDefinition": "\${api.path}"): {
                (
                    scaffoldAsyncApiConfigs(api, protocols)
                )
            },
            lookupElementFromApp(
                existingConfiguration,
                (value, key, index) -> key ~= "config" and value.@apiDefinition?
            )
        )
        
    )
}
