%dw 2.0
import fail from dw::Runtime
import scripts::asyncapi::protocol::KafkaModule

fun scaffoldAsyncApiConfigs(api, protocols: Array<String>) = 
    protocols map
        $ match  {
            case name if (name contains "kafka") -> KafkaModule::scaffoldAsyncApiConfig(api)
            else -> fail('Unsupported protocol: ' ++ $)
        }

fun scaffoldProtocolConfigs(api, protocols: Array<String>, existingConfiguration) = 
    protocols map
        $ match {
                case name if (name contains "kafka") ->
                    KafkaModule::scaffoldConfigs(api, existingConfiguration)
                else -> fail('Unsupported protocol: ' ++ $)
        }

/*
 * Given an array of protocol names, return an array of
 * corresponding schema locations.
 */
fun getSchemaLocations(protocols: Array<String>): Array<String> =
    protocols map (
        $ match {
            case name if (name contains "kafka") -> KafkaModule::getSchemaLocation()
            else -> fail('Unsupported protocol: ' ++ $)
        }
    )

fun getEnvironmentFile(api, protocols, apiPath) =
    protocols reduce ((protocol, acc = []) -> 
        protocol match {
            case name if (name contains "kafka") -> acc ++ KafkaModule::getEnvironmentFile(api, apiPath)
            else -> fail('Unsupported protocol: ' ++ $)
        }
    )