%dw 2.0
import * from scripts::graphql::GraphqlModule
import getMuleNamespaces from scripts::modules::SharedComponentsModule
import getSchemaLocations from scripts::asyncapi::protocol::ProtocolAdapterModule
import getServerProtocols, getMuleNamespacesByProtocolSchemas, getAsyncApiSchemaLocation from scripts::asyncapi::AsyncApiModule

input api application/json
input configsContent application/java
input specification text/plain
output application/xml defaultNamespace="http://www.mulesoft.org/schema/mule/core"

var content = configsContent map read($,"application/xml").mule filter $ != null

var namespaces =
    specification match {
        case spec if (spec == "GraphQL") ->
            getMuleNamespaces(scripts::graphql::GraphqlModule::graphqlSchemaLocations)
        case spec if (spec == "ASYNC 2.0") -> do {
            var schemas = [getAsyncApiSchemaLocation()] ++ getSchemaLocations(getServerProtocols(api))
            ---
            getMuleNamespacesByProtocolSchemas(schemas)
        }
        else -> {}
    }
---
mule @((namespaces)) :
{
   (content)
}
