%dw 2.0
import scripts::asyncapi::AsyncApiModule
import scripts::graphql::GraphqlModule
import * from scripts::modules::PropertiesModule
import scripts::asyncapi::protocol::ProtocolAdapterModule

input api application/json
input apiPath text/plain
input propertyFiles application/java
output application/java

var classifier = (apiPath splitBy ":")[5]

var environmentFile =
    classifier match {
        case classifier if (classifier contains "graphql") ->
            GraphqlModule::getEnvironmentFile(apiPath)
        case classifier if (classifier contains "evented-api") ->
            ProtocolAdapterModule::getEnvironmentFile(api, AsyncApiModule::getServerProtocols(api), apiPath)
        else -> []
    }
---
getParsedEnvironmentFiles(propertyFiles)
    mapValues addRequiredProperties($, environmentFile)
    mapValues write($, 'text/x-java-properties')