/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input;

import java.util.Collection;
import java.util.regex.Matcher;
import org.mule.module.apikit.helpers.FlowName;
import org.mule.raml.interfaces.common.RamlUtils;

public class APIKitFlow {
    public static final String UNNAMED_CONFIG_NAME = "noNameConfig";
    private final String action;
    private final String resource;
    private final String configRef;
    private final String mimeType;

    public APIKitFlow(String action, String resource, String mimeType, String configRef) {
        this.action = action;
        this.resource = resource;
        this.mimeType = mimeType;
        this.configRef = configRef != null ? configRef : UNNAMED_CONFIG_NAME;
    }

    public String getAction() {
        return this.action;
    }

    public String getResource() {
        return this.resource;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getConfigRef() {
        return this.configRef;
    }

    public static APIKitFlow buildFromName(String name, Collection<String> existingConfigs) {
        Matcher matcher = FlowName.getMatcher((String)name);
        String action = FlowName.getAction((Matcher)matcher);
        if (!RamlUtils.isValidAction((String)action)) {
            throw new IllegalArgumentException(action + " is not a valid action type");
        }
        String resource = FlowName.getResource((Matcher)matcher);
        String mimeType = FlowName.getMimeType((Matcher)matcher, existingConfigs).orElse(null);
        String config = FlowName.getConfig((Matcher)matcher, existingConfigs).orElse(null);
        return new APIKitFlow(action, resource, mimeType, config);
    }
}

