/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.mule.parser.service.ComponentScaffoldingError;
import org.mule.parser.service.ParserService;
import org.mule.parser.service.logger.Logger;
import org.mule.raml.interfaces.ParserWrapper;
import org.mule.raml.interfaces.loader.ResourceLoader;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IMimeType;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.api.ApiRef;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.APIFactory;
import org.mule.tools.apikit.model.ResourceActionMimeTypeTriplet;
import org.mule.tools.apikit.model.ScaffolderResourceLoader;
import org.mule.tools.apikit.model.Status;
import org.mule.tools.apikit.output.GenerationModel;

public class RAMLFilesParser {
    private Map<ResourceActionMimeTypeTriplet, GenerationModel> entries = new HashMap<ResourceActionMimeTypeTriplet, GenerationModel>();
    private final APIFactory apiFactory;
    private final Log LOGGER;
    private String ramlVersion;
    private static String vendorId = "RAML";
    public static final String MULE_APIKIT_PARSER = "mule.apikit.parser";
    private final Status parseStatus;
    private final List<ComponentScaffoldingError> parsingErrors = new ArrayList<ComponentScaffoldingError>();
    private final Set<API> apis = new HashSet<API>();

    private RAMLFilesParser(Log log, List<ApiRef> specs, APIFactory apiFactory, ScaffolderResourceLoader scaffolderResourceLoader) {
        this.LOGGER = log;
        this.apiFactory = apiFactory;
        ArrayList<ApiRef> processedFiles = new ArrayList<ApiRef>();
        for (ApiRef spec : specs) {
            try {
                ParserWrapper parserWrapper = this.getParserWrapper(spec, scaffolderResourceLoader);
                parserWrapper.validate();
                vendorId = parserWrapper.getApiVendor().toString();
                IRaml raml = parserWrapper.build();
                this.ramlVersion = raml.getVersion();
                this.collectResources(spec.getLocation(), raml.getResources(), "http://0.0.0.0:8081/api", raml.getVersion());
                processedFiles.add(spec);
            }
            catch (Exception e) {
                String reason = e.getMessage() == null ? "" : " Reason: " + e.getMessage();
                log.info((CharSequence)("Could not parse [" + spec.getLocation() + "] as root RAML file." + reason));
                log.debug((Throwable)e);
            }
        }
        if (processedFiles.size() > 0) {
            this.LOGGER.info((CharSequence)("The following RAML files were parsed correctly: " + processedFiles));
            this.parseStatus = this.parsingErrors.size() == 0 ? Status.SUCCESS : Status.SUCCESS_WITH_ERRORS;
        } else {
            this.LOGGER.error((CharSequence)"None of the files was recognized as a valid root API file. See the Error Log for more details");
            this.parseStatus = Status.FAILED;
        }
    }

    public static RAMLFilesParser create(Log log, Map<File, InputStream> fileStreams, APIFactory apiFactory) {
        List<ApiRef> specs = fileStreams.entrySet().stream().map(e -> ApiRef.create((String)((File)e.getKey()).getAbsolutePath())).collect(Collectors.toList());
        return new RAMLFilesParser(log, specs, apiFactory, null);
    }

    public static RAMLFilesParser create(Log log, Map<String, InputStream> apis, APIFactory apiFactory, ScaffolderResourceLoader scaffolderResourceLoader) {
        List<ApiRef> specs = apis.entrySet().stream().map(e -> ApiRef.create((String)((String)e.getKey()), (ResourceLoader)scaffolderResourceLoader)).collect(Collectors.toList());
        return new RAMLFilesParser(log, specs, apiFactory, scaffolderResourceLoader);
    }

    public Status getParseStatus() {
        return this.parseStatus;
    }

    public String getVendorId() {
        return vendorId;
    }

    public String getRamlVersion() {
        return this.ramlVersion;
    }

    public List<ComponentScaffoldingError> getParsingErrors() {
        return this.parsingErrors;
    }

    public Set<API> getApis() {
        return this.apis;
    }

    private void collectResources(String filePath, Map<String, IResource> resourceMap, String baseUri, String version) {
        API api = this.apiFactory.createAPIBinding(filePath, null, baseUri, APIKitTools.getPathFromUri(baseUri, false), null, null);
        this.apis.add(api);
        for (IResource resource : resourceMap.values()) {
            for (IAction action : resource.getActions().values()) {
                Map mimeTypes = action.getBody();
                boolean addGenericAction = false;
                if (mimeTypes != null && !mimeTypes.isEmpty()) {
                    for (IMimeType mimeType : mimeTypes.values()) {
                        if (mimeType.getSchema() != null || mimeType.getFormParameters() != null && !mimeType.getFormParameters().isEmpty()) {
                            this.addResource(api, resource, action, mimeType.getType(), version);
                            continue;
                        }
                        addGenericAction = true;
                    }
                } else {
                    addGenericAction = true;
                }
                if (!addGenericAction) continue;
                this.addResource(api, resource, action, null, version);
            }
            this.collectResources(filePath, resource.getResources(), baseUri, version);
        }
    }

    private void addResource(API api, IResource resource, IAction action, String mimeType, String version) {
        String completePath = APIKitTools.getCompletePathFromBasePathAndPath(api.getHttpListenerConfig().getBasePath(), api.getPath());
        ResourceActionMimeTypeTriplet resourceActionTriplet = new ResourceActionMimeTypeTriplet(api, completePath + resource.getResolvedUri(version), action.getType().toString(), mimeType);
        this.entries.put(resourceActionTriplet, new GenerationModel(api, version, resource, action, mimeType));
    }

    public Map<ResourceActionMimeTypeTriplet, GenerationModel> getEntries() {
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParserWrapper getParserWrapper(ApiRef apiRef, ScaffolderResourceLoader scaffolderResourceLoader) {
        ParserService parserService = new ParserService((Logger)LoggerWrapper.getLogger(this.LOGGER));
        try {
            ParserWrapper parser = parserService.getParser(ApiRef.create((String)apiRef.getLocation(), (ResourceLoader)scaffolderResourceLoader));
            this.LOGGER.info((CharSequence)String.format("Using %s to load APIs", parser.getParserType().name()));
            ParserWrapper parserWrapper = parser;
            return parserWrapper;
        }
        finally {
            this.parsingErrors.addAll(parserService.getParsingErrors());
        }
    }

    private static class LoggerWrapper
    implements Logger {
        private final Log LOGGER;

        private LoggerWrapper(Log logger) {
            this.LOGGER = logger;
        }

        static LoggerWrapper getLogger(Log logger) {
            return new LoggerWrapper(logger);
        }

        public void debug(String msg) {
            this.LOGGER.debug((CharSequence)msg);
        }

        public void debug(String msg, Throwable error) {
            this.LOGGER.debug((CharSequence)msg, error);
        }

        public void info(String msg) {
            this.LOGGER.info((CharSequence)msg);
        }

        public void info(String msg, Throwable error) {
            this.LOGGER.info((CharSequence)msg, error);
        }

        public void warn(String msg) {
            this.LOGGER.warn((CharSequence)msg);
        }

        public void warn(String msg, Throwable error) {
            this.LOGGER.warn((CharSequence)msg, error);
        }

        public void error(String msg) {
            this.LOGGER.error((CharSequence)msg);
        }

        public void error(String msg, Throwable error) {
            this.LOGGER.error((CharSequence)msg, error);
        }
    }
}

