/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public class FileListUtils {
    private final Log log;

    public FileListUtils(Log log) {
        this.log = log;
    }

    public FileListUtils() {
        this.log = null;
    }

    public Map<File, InputStream> toStreamsOrFail(List<String> absolutePaths) throws IOException {
        Map<File, InputStream> streams = this.toFiles(absolutePaths, element -> new File((String)element));
        if ((streams == null || streams.size() == 0) && absolutePaths.size() > 0) {
            throw new IOException("Error: None of the following files could be parsed: " + absolutePaths);
        }
        return streams;
    }

    public <T> Map<File, InputStream> toFiles(List<T> elements, TransformToFile<T> elementToFile) {
        LinkedHashMap<File, InputStream> fileStreams = new LinkedHashMap<File, InputStream>();
        for (T element : elements) {
            File file = elementToFile.transform(element);
            try {
                fileStreams.put(file, new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                if (this.log == null) {
                    throw new RuntimeException(e);
                }
                this.log.error((CharSequence)String.format("Error opening file [ %s ]", file), (Throwable)e);
            }
        }
        return fileStreams;
    }

    @FunctionalInterface
    public static interface TransformToFile<T> {
        public File transform(T var1);
    }
}

