/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.mule.raml.interfaces.common.APISyncUtils;
import org.mule.tools.apikit.Scaffolder;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.RuntimeEdition;
import org.mule.tools.apikit.model.ScaffolderReport;
import org.mule.tools.apikit.model.ScaffolderResourceLoader;

public class ScaffolderAPI {
    private static final List<String> apiExtensions = Arrays.asList(".yaml", ".raml", ".yml", ".json");
    private static final List<String> appExtensions = Arrays.asList(".xml");

    public ScaffolderReport run(List<File> ramlFiles, File appDir) {
        return this.run(ramlFiles, appDir, null, "4.0.0", Scaffolder.DEFAULT_RUNTIME_EDITION);
    }

    public ScaffolderReport run(List<File> ramlFiles, File appDir, File domainDir) {
        return this.run(ramlFiles, appDir, domainDir, "4.0.0", Scaffolder.DEFAULT_RUNTIME_EDITION);
    }

    public ScaffolderReport run(List<File> ramlFiles, File appDir, File domainDir, String minMuleVersion, RuntimeEdition runtimeEdition) {
        return this.execute(ramlFiles, appDir, domainDir, minMuleVersion, runtimeEdition);
    }

    public ScaffolderReport run(List<Dependency> dependencyList, ScaffolderResourceLoader scaffolderResourceLoader, File appDir, File domainDir, String minMuleVersion, RuntimeEdition runtimeEdition) {
        return this.execute(dependencyList, scaffolderResourceLoader, appDir, domainDir, minMuleVersion, runtimeEdition);
    }

    private ScaffolderReport execute(List<Dependency> dependencyList, ScaffolderResourceLoader scaffolderResourceLoader, File appDir, File domainDir, String minMuleVersion, RuntimeEdition runtimeEdition) {
        Scaffolder scaffolder;
        try {
            List<String> domainFiles;
            Map<String, InputStream> apiSpecs = this.getApiSpecs(dependencyList, scaffolderResourceLoader);
            List<String> muleXmlFiles = this.retrieveFilePaths(appDir, appExtensions);
            SystemStreamLog log = new SystemStreamLog();
            String domain = null;
            if (domainDir != null && (domainFiles = this.retrieveFilePaths(domainDir, appExtensions)).size() > 0) {
                domain = domainFiles.get(0);
                if (domainFiles.size() > 1) {
                    log.info((CharSequence)("There is more than one domain file inside of the domain folder. The domain: " + domain + " will be used."));
                }
            }
            scaffolder = Scaffolder.createScaffolder(log, appDir, apiSpecs, scaffolderResourceLoader, muleXmlFiles, domain, minMuleVersion, runtimeEdition);
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing scaffolder", e);
        }
        scaffolder.run();
        return scaffolder.getScaffolderReport();
    }

    private Map<String, InputStream> getApiSpecs(List<Dependency> dependencyList, ScaffolderResourceLoader scaffolderResourceLoader) throws IOException {
        HashMap<String, InputStream> apiSpecs = new HashMap<String, InputStream>();
        for (Dependency dependency : dependencyList) {
            String dependencyResourceFormat = String.format("resource::%s:%s:%s:%s:%s:%s", dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.getType(), "%s");
            InputStream exchangeJson = scaffolderResourceLoader.getResourceAsStream(String.format(dependencyResourceFormat, "exchange.json"));
            String rootApiFileName = APISyncUtils.getMainApi((String)APIKitTools.readContents(exchangeJson));
            String rootApiResource = String.format(dependencyResourceFormat, rootApiFileName);
            InputStream rootApi = scaffolderResourceLoader.getResourceAsStream(rootApiResource);
            apiSpecs.put(rootApiResource, rootApi);
        }
        return apiSpecs;
    }

    private ScaffolderReport execute(List<File> ramlFiles, File appDir, File domainDir, String minMuleVersion, RuntimeEdition runtimeEdition) {
        Scaffolder scaffolder;
        List<String> domainFiles;
        List<String> ramlFilePaths = this.retrieveFilePaths(ramlFiles, apiExtensions);
        List<String> muleXmlFiles = this.retrieveFilePaths(appDir, appExtensions);
        SystemStreamLog log = new SystemStreamLog();
        String domain = null;
        if (domainDir != null && (domainFiles = this.retrieveFilePaths(domainDir, appExtensions)).size() > 0) {
            domain = domainFiles.get(0);
            if (domainFiles.size() > 1) {
                log.info((CharSequence)("There is more than one domain file inside of the domain folder. The domain: " + domain + " will be used."));
            }
        }
        try {
            scaffolder = Scaffolder.createScaffolder((Log)log, appDir, ramlFilePaths, muleXmlFiles, domain, minMuleVersion, runtimeEdition);
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing scaffolder", e);
        }
        scaffolder.run();
        return scaffolder.getScaffolderReport();
    }

    private List<String> retrieveFilePaths(File dir, List<String> extensions) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("File " + dir.getName() + " must be a directory");
        }
        return this.retrieveFilePaths(new ArrayList<File>(Arrays.asList(dir.listFiles())), extensions);
    }

    private List<String> retrieveFilePaths(List<File> files, List<String> extensions) {
        ArrayList<String> filePaths = new ArrayList<String>();
        if (files != null) {
            for (File file : files) {
                if (!this.containsValidExtension(file, extensions)) continue;
                filePaths.add(file.getAbsolutePath());
            }
        }
        return filePaths;
    }

    private boolean containsValidExtension(File file, List<String> extensions) {
        for (String extension : extensions) {
            if (!file.getName().toLowerCase().endsWith(extension)) continue;
            return true;
        }
        return false;
    }
}

