/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.codehaus.plexus.util.FileUtils;
import org.mule.raml.interfaces.common.APISyncUtils;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.model.HttpListener4xConfig;
import org.mule.tools.apikit.model.HttpListenerConnection;

public class APIFactory {
    private static final String RESOURCE_API_FOLDER = "src" + File.separator + "main" + File.separator + "resources" + File.separator + "api" + File.separator;
    private Map<String, API> apis = new HashMap<String, API>();
    private final Map<String, HttpListener4xConfig> httpListenerConfigs = new HashMap<String, HttpListener4xConfig>();

    public APIFactory(Map<String, HttpListener4xConfig> httpListenerConfigs) {
        this.httpListenerConfigs.putAll(httpListenerConfigs);
    }

    public APIFactory() {
    }

    public API createAPIBindingInboundEndpoint(String apiFileName, File xmlFile, String baseUri, String path, APIKitConfig config) {
        return this.createAPIBinding(apiFileName, xmlFile, baseUri, path, config, null);
    }

    public API createAPIBinding(String apiFilePath, File xmlFile, String baseUri, String path, APIKitConfig config, HttpListener4xConfig httpListenerConfig) {
        Validate.notNull((Object)apiFilePath);
        String relativePath = this.getRelativePath(apiFilePath);
        if (this.apis.containsKey(relativePath)) {
            API api = this.apis.get(relativePath);
            if (api.getXmlFile() == null && xmlFile != null) {
                api.setXmlFile(xmlFile);
            }
            return api;
        }
        String id = this.buildApiId(relativePath);
        API api = new API(id, relativePath, xmlFile, baseUri, path, config);
        if (httpListenerConfig == null) {
            HttpListener4xConfig availableConfig = this.getAvailableLCForPath(path, this.httpListenerConfigs);
            if (availableConfig != null) {
                api.setHttpListenerConfig(availableConfig);
            } else {
                HttpListener4xConfig defaultHttpListenerConfig = this.buildDefaultHttpListenerConfig(id);
                this.httpListenerConfigs.put(defaultHttpListenerConfig.getName(), defaultHttpListenerConfig);
                api.setHttpListenerConfig(defaultHttpListenerConfig);
            }
        } else {
            api.setHttpListenerConfig(httpListenerConfig);
        }
        if (config != null) {
            config.setApi(apiFilePath);
        }
        api.setConfig(config);
        this.apis.put(relativePath, api);
        return api;
    }

    private HttpListener4xConfig buildDefaultHttpListenerConfig(String id) {
        String nextPort = APIFactory.getNextPort(this.httpListenerConfigs);
        HttpListenerConnection listenerConnection = this.buildDefaultHttpListenerConnection(nextPort);
        String httpListenerConfigName = id == null ? "httpListenerConfig" : id + "-" + "httpListenerConfig";
        return new HttpListener4xConfig(httpListenerConfigName, "/", listenerConnection);
    }

    private static String getNextPort(Map<String, HttpListener4xConfig> httpListenerConfigs) {
        List<Map.Entry<String, HttpListener4xConfig>> numericPortListeners = APIFactory.getNumericPortListenersAsList(httpListenerConfigs);
        if (numericPortListeners.size() > 0) {
            String greaterPort = numericPortListeners.get(numericPortListeners.size() - 1).getValue().getPort();
            return String.valueOf(Integer.parseInt(greaterPort) + 1);
        }
        return "8081";
    }

    private HttpListenerConnection buildDefaultHttpListenerConnection(String port) {
        return new HttpListenerConnection.Builder().setHost("0.0.0.0").setPort(port).setProtocol("HTTP").build();
    }

    private String buildApiId(String ramlFilePath) {
        String id;
        String apiId = APISyncUtils.isSyncProtocol((String)ramlFilePath) ? FilenameUtils.removeExtension((String)APISyncUtils.getFileName((String)ramlFilePath)) : FilenameUtils.removeExtension((String)FileUtils.basename((String)ramlFilePath)).trim();
        List apiIds = this.apis.values().stream().map(API::getId).collect(Collectors.toList());
        List configNames = this.apis.values().stream().filter(a -> a.getConfig() != null).map(a -> a.getConfig().getName()).collect(Collectors.toList());
        List httpConfigNames = this.apis.values().stream().filter(a -> a.getHttpListenerConfig() != null).map(a -> a.getHttpListenerConfig().getName()).collect(Collectors.toList());
        int count = 0;
        while (apiIds.contains(id = ++count > 1 ? apiId + "-" + count : apiId) || configNames.contains(id + "-" + "config") || httpConfigNames.contains(id + "-" + "httpListenerConfig")) {
        }
        return id;
    }

    private String getRelativePath(String path) {
        if (!APISyncUtils.isSyncProtocol((String)path) && !path.startsWith("http://") && !path.startsWith("https://") && path.contains(RESOURCE_API_FOLDER)) {
            return path.substring(path.lastIndexOf(RESOURCE_API_FOLDER) + RESOURCE_API_FOLDER.length());
        }
        return path;
    }

    public Map<String, HttpListener4xConfig> getHttpListenerConfigs() {
        return this.httpListenerConfigs;
    }

    private HttpListener4xConfig getAvailableLCForPath(String path, Map<String, HttpListener4xConfig> httpListenerConfigs) {
        if (httpListenerConfigs.size() <= 0) {
            return null;
        }
        List usedListeners = this.apis.entrySet().stream().filter(e -> {
            String apiPath = ((API)e.getValue()).getPath();
            return path.equals(apiPath) || (path + "/*").equals(apiPath);
        }).map(e -> ((API)e.getValue()).getHttpListenerConfig()).collect(Collectors.toList());
        ArrayList<Map.Entry<String, HttpListener4xConfig>> availableListeners = new ArrayList<Map.Entry<String, HttpListener4xConfig>>();
        availableListeners.addAll(APIFactory.getNumericPortListenersAsList(httpListenerConfigs));
        availableListeners.addAll(APIFactory.getNonNumericPortListeners(httpListenerConfigs).entrySet());
        return availableListeners.stream().map(Map.Entry::getValue).filter(l -> !usedListeners.contains(l)).findFirst().orElse(null);
    }

    private static Map<String, HttpListener4xConfig> getNumericPortListeners(Map<String, HttpListener4xConfig> httpListenerConfigs) {
        return httpListenerConfigs.entrySet().stream().filter(entry -> StringUtils.isNumeric((String)((HttpListener4xConfig)entry.getValue()).getPort())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static List<Map.Entry<String, HttpListener4xConfig>> getNumericPortListenersAsList(Map<String, HttpListener4xConfig> httpListenerConfigs) {
        ArrayList<Map.Entry<String, HttpListener4xConfig>> numericPortsList = new ArrayList<Map.Entry<String, HttpListener4xConfig>>(APIFactory.getNumericPortListeners(httpListenerConfigs).entrySet());
        numericPortsList.sort((o1, o2) -> {
            Integer i1 = Integer.parseInt(((HttpListener4xConfig)o1.getValue()).getPort());
            Integer i2 = Integer.parseInt(((HttpListener4xConfig)o2.getValue()).getPort());
            return i1.compareTo(i2);
        });
        return numericPortsList;
    }

    private static Map<String, HttpListener4xConfig> getNonNumericPortListeners(Map<String, HttpListener4xConfig> httpListenerConfigs) {
        return httpListenerConfigs.entrySet().stream().filter(entry -> !StringUtils.isNumeric((String)((HttpListener4xConfig)entry.getValue()).getPort())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

