/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.parser.service.ComponentScaffoldingError;
import org.mule.parser.service.ScaffoldingErrorType;
import org.mule.tools.apikit.model.Status;

public class ScaffolderReport {
    private final String vendorId;
    private final String version;
    private final Status status;
    private final List<ComponentScaffoldingError> scaffoldingErrors;

    private ScaffolderReport(String vendorId, String version, Status status, List<ComponentScaffoldingError> errors) {
        this.vendorId = vendorId;
        this.version = version;
        this.status = status;
        this.scaffoldingErrors = errors;
    }

    public String getVersion() {
        return this.version;
    }

    public String getStatus() {
        return this.status.toString();
    }

    public String getVendorId() {
        return this.vendorId;
    }

    public List<ComponentScaffoldingError> getScaffoldingErrors() {
        return this.scaffoldingErrors;
    }

    public List<ComponentScaffoldingError> getScaffoldingErrorsByType(ScaffoldingErrorType type) {
        return this.scaffoldingErrors.stream().filter(e -> type.equals((Object)e.errorType())).collect(Collectors.toList());
    }

    public static class Builder {
        private String vendorId;
        private String version;
        private Status status;
        private final List<ComponentScaffoldingError> parsingErrors = new ArrayList<ComponentScaffoldingError>();

        public Builder withVendorId(String vendorId) {
            this.vendorId = vendorId;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withStatus(Status status) {
            this.status = status;
            return this;
        }

        public Builder withScaffoldingErrors(List<ComponentScaffoldingError> errors) {
            this.parsingErrors.addAll(errors);
            return this;
        }

        public ScaffolderReport build() {
            return new ScaffolderReport(this.vendorId, this.version, this.status, this.parsingErrors);
        }
    }
}

