/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.scopes;

import org.jdom2.Content;
import org.jdom2.Element;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.HttpListener4xConfig;
import org.mule.tools.apikit.output.MuleConfigGenerator;
import org.mule.tools.apikit.output.scopes.Scope;

public class HttpListenerConfigMule4Scope
implements Scope {
    private final Element mule;
    private final Element httpListenerConfig;

    public HttpListenerConfigMule4Scope(API api, Element mule) {
        this.mule = mule;
        HttpListener4xConfig httpListenerConfig = api.getHttpListenerConfig();
        if (httpListenerConfig != null) {
            this.httpListenerConfig = new Element("listener-config", MuleConfigGenerator.HTTP_NAMESPACE.getNamespace());
            this.httpListenerConfig.setAttribute("name", httpListenerConfig.getName());
            String basePath = httpListenerConfig.getBasePath();
            if (basePath != null && basePath != "/" && basePath != "") {
                this.httpListenerConfig.setAttribute("basePath", httpListenerConfig.getBasePath());
            }
            mule.addContent((Content)this.httpListenerConfig);
            Element connection = new Element("listener-connection", MuleConfigGenerator.HTTP_NAMESPACE.getNamespace());
            connection.setAttribute("host", httpListenerConfig.getHost());
            connection.setAttribute("port", httpListenerConfig.getPort());
            this.httpListenerConfig.addContent((Content)connection);
            httpListenerConfig.setPeristed(true);
        } else {
            this.httpListenerConfig = null;
        }
    }

    @Override
    public Element generate() {
        return this.httpListenerConfig;
    }
}

