/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.misc;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class FlowNameUtils {
    public static final String FLOW_NAME_SEPARATOR = ":";
    public static final String URL_RESOURCE_SEPARATOR = "/";
    private static final ImmutableMap<String, String> specialCharacters = ImmutableMap.builder().put((Object)"/", (Object)"\\").put((Object)"{", (Object)"(").put((Object)"}", (Object)")").build();
    private static final String APIKIT_FLOW_NAME_FORMAT = "^([^:]+):(/[^:]*)(:([^:]+))?(:(.*))?$";
    private static final Pattern PATTERN = Pattern.compile("^([^:]+):(/[^:]*)(:([^:]+))?(:(.*))?$");

    public static Matcher getMatcher(String flowName) {
        if (StringUtils.isEmpty((String)flowName)) {
            throw new IllegalArgumentException("Flow name cannot be null or empty");
        }
        Matcher flowNameMatcher = PATTERN.matcher(flowName);
        if (!flowNameMatcher.find()) {
            throw new IllegalArgumentException("Invalid apikit flow name, expected format is: action:resource[:config]");
        }
        return flowNameMatcher;
    }

    public static String encode(String value) {
        for (Map.Entry entry : specialCharacters.entrySet()) {
            value = value.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return value;
    }

    public static String decode(String value) {
        for (Map.Entry entry : specialCharacters.entrySet()) {
            value = value.replace((CharSequence)entry.getValue(), (CharSequence)entry.getKey());
        }
        return value;
    }

    public static String getAction(Matcher flowNameMatcher) {
        return flowNameMatcher.group(1);
    }

    public static String getResource(String flowName) {
        return FlowNameUtils.getResource(FlowNameUtils.getMatcher(flowName));
    }

    public static String getResource(Matcher flowNameMatcher) {
        return flowNameMatcher.group(2);
    }

    public static Optional<String> getMimeType(Matcher flowNameMatcher, Collection<String> existingConfigs) {
        if (flowNameMatcher.group(4) != null) {
            if (flowNameMatcher.group(6) == null) {
                if (existingConfigs == null || !existingConfigs.contains(flowNameMatcher.group(4))) {
                    return Optional.of(flowNameMatcher.group(4));
                }
            } else {
                return Optional.of(flowNameMatcher.group(4));
            }
        }
        return Optional.empty();
    }

    public static Optional<String> getConfig(Matcher flowNameMatcher, Collection<String> existingConfigs) {
        if (flowNameMatcher.group(4) != null) {
            if (flowNameMatcher.group(6) == null) {
                if (existingConfigs != null && existingConfigs.contains(flowNameMatcher.group(4))) {
                    return Optional.of(flowNameMatcher.group(4));
                }
            } else {
                return Optional.of(flowNameMatcher.group(6));
            }
        }
        return Optional.empty();
    }
}

