/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.ApikitMainFlowContainer;
import org.mule.tools.apikit.model.Flow;
import org.mule.tools.apikit.model.MuleConfig;
import org.mule.tools.apikit.model.MuleConfigBuilder;
import org.mule.tools.apikit.model.RuntimeEdition;
import org.mule.tools.apikit.model.ScaffolderContext;
import org.mule.tools.apikit.output.GenerationModel;
import org.mule.tools.apikit.output.NamespaceWithLocation;
import org.mule.tools.apikit.output.scopes.APIKitFlowScope;
import org.mule.tools.apikit.output.scopes.ConsoleFlowScope;
import org.mule.tools.apikit.output.scopes.FlowScope;
import org.mule.tools.apikit.output.scopes.MuleScope;

public class MuleConfigGenerator {
    public static final NamespaceWithLocation XMLNS_NAMESPACE = new NamespaceWithLocation(Namespace.getNamespace((String)"http://www.mulesoft.org/schema/mule/core"), "http://www.mulesoft.org/schema/mule/core/current/mule.xsd");
    public static final NamespaceWithLocation XSI_NAMESPACE = new NamespaceWithLocation(Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"), null);
    public static final NamespaceWithLocation HTTP_NAMESPACE = new NamespaceWithLocation(Namespace.getNamespace((String)"http", (String)"http://www.mulesoft.org/schema/mule/http"), "http://www.mulesoft.org/schema/mule/http/current/mule-http.xsd");
    public static final NamespaceWithLocation EE_NAMESPACE = new NamespaceWithLocation(Namespace.getNamespace((String)"ee", (String)"http://www.mulesoft.org/schema/mule/ee/core"), "http://www.mulesoft.org/schema/mule/ee/core/current/mule-ee.xsd");
    private final List<GenerationModel> flowEntries;
    private final List<ApikitMainFlowContainer> apis;
    private List<MuleConfig> muleConfigsInApp = new ArrayList<MuleConfig>();
    private ScaffolderContext scaffolderContext;

    public MuleConfigGenerator(List<ApikitMainFlowContainer> apis, List<GenerationModel> flowEntries, List<MuleConfig> muleConfigsInApp, ScaffolderContext scaffolderContext) {
        this.apis = apis;
        this.flowEntries = flowEntries;
        this.muleConfigsInApp.addAll(muleConfigsInApp);
        this.scaffolderContext = scaffolderContext;
    }

    public List<MuleConfig> generate() {
        ArrayList<MuleConfig> configs = new ArrayList<MuleConfig>();
        if (this.flowEntries.isEmpty()) {
            this.apis.forEach(api -> {
                MuleConfig muleConfig = api.getMuleConfig() != null ? api.getMuleConfig() : this.createMuleConfig((ApikitMainFlowContainer)api);
                this.updateApikitConfig((ApikitMainFlowContainer)api, muleConfig);
                configs.add(muleConfig);
            });
        } else {
            HashSet<MuleConfig> muleConfigs = new HashSet<MuleConfig>();
            ApikitMainFlowContainer api2 = this.flowEntries.get(0).getApi();
            MuleConfig muleConfig = api2.getMuleConfig() != null ? api2.getMuleConfig() : this.createMuleConfig(api2);
            for (GenerationModel flowEntry : this.flowEntries) {
                Element apikitFlowScope = new APIKitFlowScope(flowEntry, this.isMuleEE()).generate();
                int newFlowPositionIndex = this.getLastFlowIndex(muleConfig.getContentAsDocument()) + 1;
                muleConfig.getContentAsDocument().getRootElement().getContent().add(newFlowPositionIndex, apikitFlowScope);
                muleConfig.addFlow(new Flow(apikitFlowScope));
                this.updateApikitConfig(api2, muleConfig);
                muleConfigs.add(muleConfig);
            }
            configs.addAll(muleConfigs);
        }
        return configs;
    }

    private void setDefaultApikitAndListenersConfigs(ApikitMainFlowContainer api, MuleConfig muleConfig) {
        if (api.getConfig() == null || api.getHttpListenerConfig() == null) {
            if (api.getConfig() == null) {
                api.setDefaultAPIKitConfig();
            }
            this.generateAPIKitAndListenerConfig(api, muleConfig);
        }
    }

    private int getLastFlowIndex(Document doc) {
        int lastFlowIndex = 0;
        for (int i = 0; i < doc.getRootElement().getContentSize(); ++i) {
            Content content = doc.getRootElement().getContent(i);
            if (!(content instanceof Element) || !"flow".equals(((Element)content).getName())) continue;
            lastFlowIndex = i;
        }
        return lastFlowIndex;
    }

    private void updateApikitConfig(ApikitMainFlowContainer api, MuleConfig config) {
        Element apikitConfiFromMuleConfig = config.getContentAsDocument().getRootElement().getChild("config", APIKitTools.API_KIT_NAMESPACE.getNamespace());
        Element apikitConfigFromApi = api.getConfig().generate();
        if (this.shouldUpdateApikitConfig(apikitConfigFromApi, apikitConfiFromMuleConfig)) {
            int index = config.getContentAsDocument().getRootElement().indexOf((Content)apikitConfiFromMuleConfig);
            config.getContentAsDocument().getRootElement().removeContent(index);
            config.getContentAsDocument().getRootElement().addContent(index, (Content)apikitConfigFromApi);
        }
    }

    public MuleConfig createMuleConfig(ApikitMainFlowContainer api) {
        Document document = new Document();
        document.setRootElement(new MuleScope(false, false).generate());
        MuleConfig mConfig = MuleConfigBuilder.fromDoc(document);
        mConfig.setName(api.getId() + ".xml");
        this.setDefaultApikitAndListenersConfigs(api, mConfig);
        MuleConfig config = MuleConfigBuilder.fromDoc(mConfig.buildContent());
        config.setName(mConfig.getName());
        api.setMuleConfig(config);
        this.muleConfigsInApp.add(config);
        return config;
    }

    private void generateAPIKitAndListenerConfig(ApikitMainFlowContainer api, MuleConfig muleConfig) {
        if (!muleConfig.getHttpListenerConfigs().contains(api.getHttpListenerConfig())) {
            muleConfig.addHttpListener(api.getHttpListenerConfig());
        }
        api.setPath(APIKitTools.addAsteriskToPath(api.getPath()));
        muleConfig.addConfig(api.getConfig());
        muleConfig.addFlow(new Flow(new FlowScope(api, this.isMuleEE()).generate()));
        muleConfig.addFlow(new Flow(new ConsoleFlowScope(api, this.isMuleEE()).generate()));
    }

    private boolean isMuleEE() {
        return this.scaffolderContext.getRuntimeEdition() == RuntimeEdition.EE;
    }

    private boolean shouldUpdateApikitConfig(Element apikitConfigFromApi, Element apikitConfigFromMuleConfig) {
        if (apikitConfigFromMuleConfig == null) {
            return false;
        }
        for (Attribute attr : apikitConfigFromApi.getAttributes()) {
            Attribute muleConfigAttr = apikitConfigFromMuleConfig.getAttribute(attr.getName());
            if (muleConfigAttr == null) {
                return true;
            }
            if (attr.getValue().equals(muleConfigAttr.getValue())) continue;
            return true;
        }
        return false;
    }
}

