/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.scopes;

import java.util.ArrayList;
import java.util.Arrays;
import org.jdom2.Element;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.output.MuleConfigGenerator;
import org.mule.tools.apikit.output.MunitTestSuiteGenerator;
import org.mule.tools.apikit.output.NamespaceWithLocation;
import org.mule.tools.apikit.output.scopes.Scope;

public class MuleScope
implements Scope {
    private final Element mule = new Element("mule");

    private void addLocationEntry(StringBuilder stringBuilder, NamespaceWithLocation namespaceWithLocation) {
        stringBuilder.append(namespaceWithLocation.getNamespace().getURI()).append(" ").append(namespaceWithLocation.getLocation()).append(" ");
    }

    public MuleScope(boolean addEENamespace, boolean isMunitSuite) {
        StringBuilder stringBuilder = new StringBuilder();
        this.mule.setNamespace(MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
        this.mule.addNamespaceDeclaration(MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
        this.addLocationEntry(stringBuilder, MuleConfigGenerator.XMLNS_NAMESPACE);
        ArrayList<NamespaceWithLocation> namespaces = new ArrayList<NamespaceWithLocation>();
        namespaces.add(MuleConfigGenerator.HTTP_NAMESPACE);
        if (isMunitSuite) {
            this.mule.addNamespaceDeclaration(MunitTestSuiteGenerator.DOC_NAMESPACE.getNamespace());
            namespaces.addAll(Arrays.asList(MunitTestSuiteGenerator.MUNIT_NAMESPACE, MunitTestSuiteGenerator.MUNIT_TOOLS_NAMESPACE));
        } else {
            namespaces.add(APIKitTools.API_KIT_NAMESPACE);
        }
        this.mule.addNamespaceDeclaration(MuleConfigGenerator.XSI_NAMESPACE.getNamespace());
        for (NamespaceWithLocation namespace : namespaces) {
            this.mule.addNamespaceDeclaration(namespace.getNamespace());
            this.addLocationEntry(stringBuilder, namespace);
        }
        if (addEENamespace) {
            this.mule.addNamespaceDeclaration(MuleConfigGenerator.EE_NAMESPACE.getNamespace());
            this.addLocationEntry(stringBuilder, MuleConfigGenerator.EE_NAMESPACE);
        }
        this.mule.setAttribute("schemaLocation", stringBuilder.toString(), MuleConfigGenerator.XSI_NAMESPACE.getNamespace());
    }

    @Override
    public Element generate() {
        return this.mule;
    }
}

