/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.mule.tools.apikit.input.parsers.APIKitConfigParser;
import org.mule.tools.apikit.input.parsers.HttpListenerConfigParser;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.model.ApikitRouter;
import org.mule.tools.apikit.model.Flow;
import org.mule.tools.apikit.model.HttpListenerConfig;
import org.mule.tools.apikit.model.MainFlow;
import org.mule.tools.apikit.model.MuleConfig;

public class MuleConfigBuilder {
    private final List<HttpListenerConfig> httpListenerConfigs = new ArrayList<HttpListenerConfig>();
    private final List<APIKitConfig> apiKitConfigs = new LinkedList<APIKitConfig>();
    private final List<Flow> flows = new ArrayList<Flow>();

    public MuleConfig build() {
        return new MuleConfig(this.httpListenerConfigs, this.apiKitConfigs, this.flows);
    }

    public static MuleConfig fromDoc(Document muleConfigContent) {
        HttpListenerConfigParser httpConfigParser = new HttpListenerConfigParser();
        APIKitConfigParser apiKitConfigParser = new APIKitConfigParser();
        Object httpListenerConfigs = httpConfigParser.parse(muleConfigContent);
        Object apikitConfigs = apiKitConfigParser.parse(muleConfigContent);
        ArrayList<Flow> flowsInConfig = new ArrayList<Flow>();
        for (Content content : muleConfigContent.getRootElement().getContent()) {
            Element contentElement;
            if (!(content instanceof Element) || !"flow".equals((contentElement = (Element)content).getName())) continue;
            Optional<ApikitRouter> apikitRouter = MuleConfigBuilder.getRouter(contentElement);
            if (apikitRouter.isPresent()) {
                MainFlow mainFlow = new MainFlow(contentElement);
                mainFlow.setApikitRouter(apikitRouter.get());
                flowsInConfig.add(mainFlow);
                continue;
            }
            flowsInConfig.add(new Flow(contentElement));
        }
        return new MuleConfig((List<HttpListenerConfig>)httpListenerConfigs, (List<APIKitConfig>)apikitConfigs, flowsInConfig, muleConfigContent);
    }

    public static MuleConfig fromStream(InputStream input) throws Exception {
        SAXBuilder builder = MuleConfigBuilder.getSaxBuilder();
        Document inputAsDocument = builder.build(input);
        input.close();
        return MuleConfigBuilder.fromDoc(inputAsDocument);
    }

    public static Optional<ApikitRouter> getRouter(Element flow) {
        for (Content flowContent : flow.getContent()) {
            Element flowContentElement;
            if (!(flowContent instanceof Element) || !MuleConfigBuilder.elementIsApikitRouter(flowContentElement = (Element)flowContent)) continue;
            return Optional.of(new ApikitRouter(flowContentElement));
        }
        return Optional.empty();
    }

    private static boolean elementIsApikitRouter(Element element) {
        return element.getNamespace().getPrefix().equals("apikit") && element.getName().equals("router");
    }

    static SAXBuilder getSaxBuilder() {
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return builder;
    }
}

