/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import org.mule.tools.apikit.model.MunitScaffolderContext;
import org.mule.tools.apikit.model.RuntimeEdition;
import org.mule.tools.apikit.model.ScaffolderContext;

public class ScaffolderContextBuilder {
    private RuntimeEdition runtimeEdition = RuntimeEdition.CE;
    private boolean shouldCreateMunitResources = false;
    private String munitSuiteName;

    public static ScaffolderContextBuilder builder() {
        return new ScaffolderContextBuilder();
    }

    public ScaffolderContextBuilder withRuntimeEdition(RuntimeEdition runtimeEdition) {
        this.runtimeEdition = runtimeEdition;
        return this;
    }

    public ScaffolderContextBuilder shouldCreateMunitResources(boolean shouldCreateMunitResources) {
        this.shouldCreateMunitResources = shouldCreateMunitResources;
        return this;
    }

    public ScaffolderContextBuilder withMunitSuiteName(String munitSuiteName) {
        this.munitSuiteName = munitSuiteName;
        return this;
    }

    public ScaffolderContext build() {
        if (!this.shouldCreateMunitResources && this.munitSuiteName == null) {
            return new ScaffolderContext(this.runtimeEdition);
        }
        return new MunitScaffolderContext(this.runtimeEdition, this.shouldCreateMunitResources, this.munitSuiteName);
    }
}

