/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.mule.apikit.common.ApiSyncUtils;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.model.ApikitMainFlowContainer;
import org.mule.tools.apikit.model.HttpListenerConfig;
import org.mule.tools.apikit.model.HttpListenerConnection;
import org.mule.tools.apikit.model.MuleConfig;

public class APIFactory {
    private static final String RESOURCE_API_FOLDER = "src/main/resources/api/".replace("/", File.separator);
    private Map<String, ApikitMainFlowContainer> apis = new HashMap<String, ApikitMainFlowContainer>();
    private List<HttpListenerConfig> httpListenerConfigs;

    public APIFactory(List<HttpListenerConfig> httpListenerConfigs) {
        this.httpListenerConfigs = new ArrayList<HttpListenerConfig>(httpListenerConfigs);
    }

    public ApikitMainFlowContainer createAPIBindingInboundEndpoint(String apiFileName, String baseUri, String path, APIKitConfig config) {
        return this.createAPIBinding(apiFileName, baseUri, path, config, null, null);
    }

    public ApikitMainFlowContainer createAPIBinding(String apiFilePath, String baseUri, String path, APIKitConfig config, HttpListenerConfig httpListenerConfig, MuleConfig muleConfig) {
        Validate.notNull((Object)apiFilePath);
        String relativePath = this.getRelativePath(apiFilePath);
        if (this.apis.containsKey(relativePath)) {
            ApikitMainFlowContainer api = this.apis.get(relativePath);
            if (api.getMuleConfig() == null && muleConfig != null) {
                api.setMuleConfig(muleConfig);
            }
            return api;
        }
        String id = this.buildApiId(relativePath);
        ApikitMainFlowContainer api = new ApikitMainFlowContainer(id, relativePath, baseUri, path, config, muleConfig);
        if (httpListenerConfig == null) {
            HttpListenerConfig availableConfig = this.getAvailableLCForPath(path, this.httpListenerConfigs);
            if (availableConfig != null) {
                api.setHttpListenerConfig(availableConfig);
            } else {
                HttpListenerConfig defaultHttpListenerConfig = this.buildDefaultHttpListenerConfig(id);
                this.httpListenerConfigs.add(defaultHttpListenerConfig);
                api.setHttpListenerConfig(defaultHttpListenerConfig);
            }
        } else {
            api.setHttpListenerConfig(httpListenerConfig);
        }
        if (config != null) {
            config.setApi(relativePath);
        }
        api.setConfig(config);
        this.apis.put(relativePath, api);
        return api;
    }

    private HttpListenerConfig buildDefaultHttpListenerConfig(String id) {
        String nextPort = this.getNextPort(this.httpListenerConfigs);
        HttpListenerConnection listenerConnection = this.buildDefaultHttpListenerConnection(nextPort);
        String httpListenerConfigName = id == null ? "httpListenerConfig" : id + "-" + "httpListenerConfig";
        return new HttpListenerConfig(httpListenerConfigName, "/", listenerConnection);
    }

    private String getNextPort(List<HttpListenerConfig> httpListenerConfigs) {
        List<HttpListenerConfig> numericPortListeners = this.getNumericPortListenersAsList(httpListenerConfigs);
        if (numericPortListeners.size() > 0) {
            String greaterPort = numericPortListeners.get(numericPortListeners.size() - 1).getPort();
            return String.valueOf(Integer.parseInt(greaterPort) + 1);
        }
        return "8081";
    }

    private HttpListenerConnection buildDefaultHttpListenerConnection(String port) {
        return new HttpListenerConnection.Builder().setHost("0.0.0.0").setPort(port).setProtocol("HTTP").build();
    }

    private String getUriLastSegment(String ramlPathUri) {
        return ramlPathUri.substring(ramlPathUri.lastIndexOf("/") + 1);
    }

    private String sanitizeApiId(String fileName) {
        return fileName.replaceAll("\\s", "-").replaceAll("%20", "-");
    }

    private String buildApiId(String ramlFilePath) {
        String id;
        String apiId = ApiSyncUtils.isSyncProtocol((String)ramlFilePath) ? ApiSyncUtils.getFileName((String)ramlFilePath) : this.getUriLastSegment(ramlFilePath);
        apiId = FilenameUtils.removeExtension((String)this.sanitizeApiId(apiId)).trim();
        List apiIds = this.apis.values().stream().map(ApikitMainFlowContainer::getId).collect(Collectors.toList());
        List configNames = this.apis.values().stream().filter(a -> a.getConfig() != null).map(a -> a.getConfig().getName()).collect(Collectors.toList());
        List httpConfigNames = this.apis.values().stream().filter(a -> a.getHttpListenerConfig() != null).map(a -> a.getHttpListenerConfig().getName()).collect(Collectors.toList());
        int count = 0;
        while (apiIds.contains(id = ++count > 1 ? apiId + "-" + count : apiId) || configNames.contains(id + "-" + "config") || httpConfigNames.contains(id + "-" + "httpListenerConfig")) {
        }
        return id;
    }

    private String getRelativePath(String path) {
        if (!ApiSyncUtils.isSyncProtocol((String)path) && !path.startsWith("http://") && !path.startsWith("https://") && path.contains(RESOURCE_API_FOLDER)) {
            return path.substring(path.lastIndexOf(RESOURCE_API_FOLDER) + RESOURCE_API_FOLDER.length()).replace(File.separator, "/");
        }
        return path.replace(File.separator, "/");
    }

    public List<HttpListenerConfig> getHttpListenerConfigs() {
        return this.httpListenerConfigs;
    }

    private HttpListenerConfig getAvailableLCForPath(String path, List<HttpListenerConfig> httpListenerConfigs) {
        if (httpListenerConfigs.size() <= 0) {
            return null;
        }
        List usedListeners = this.apis.entrySet().stream().filter(e -> {
            String apiPath = ((ApikitMainFlowContainer)e.getValue()).getPath();
            return path.equals(apiPath) || (path + "/*").equals(apiPath);
        }).map(e -> ((ApikitMainFlowContainer)e.getValue()).getHttpListenerConfig()).collect(Collectors.toList());
        ArrayList<HttpListenerConfig> availableListeners = new ArrayList<HttpListenerConfig>();
        availableListeners.addAll(this.getNumericPortListenersAsList(httpListenerConfigs));
        availableListeners.addAll(this.getNonNumericPortListeners(httpListenerConfigs));
        return availableListeners.stream().filter(config -> !usedListeners.contains(config)).findFirst().orElse(null);
    }

    private List<HttpListenerConfig> getNumericPortListenersAsList(List<HttpListenerConfig> httpListenerConfigs) {
        return httpListenerConfigs.stream().filter(config -> StringUtils.isNumeric((String)config.getPort())).sorted((o1, o2) -> {
            Integer i1 = Integer.parseInt(o1.getPort());
            Integer i2 = Integer.parseInt(o2.getPort());
            return i1.compareTo(i2);
        }).collect(Collectors.toList());
    }

    private List<HttpListenerConfig> getNonNumericPortListeners(List<HttpListenerConfig> httpListenerConfigs) {
        return httpListenerConfigs.stream().filter(config -> !StringUtils.isNumeric((String)config.getPort())).collect(Collectors.toList());
    }
}

