/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input.parsers;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.tools.apikit.input.APIKitFlow;
import org.mule.tools.apikit.input.parsers.MuleConfigFileParser;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.misc.FlowNameUtils;
import org.mule.tools.apikit.model.ApikitMainFlowContainer;
import org.mule.tools.apikit.model.ResourceActionMimeTypeTriplet;
import org.mule.tools.apikit.output.MuleConfigGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIKitFlowsParser
implements MuleConfigFileParser<Set<ResourceActionMimeTypeTriplet>> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)APIKitFlowsParser.class.getName());
    private final Map<String, ApikitMainFlowContainer> includedApis;

    public APIKitFlowsParser(Map<String, ApikitMainFlowContainer> includedApis) {
        this.includedApis = includedApis;
    }

    @Override
    public Set<ResourceActionMimeTypeTriplet> parse(Document document) {
        HashSet<ResourceActionMimeTypeTriplet> entries = new HashSet<ResourceActionMimeTypeTriplet>();
        XPathExpression xp = XPathFactory.instance().compile("//*/*[local-name()='flow']", Filters.element((Namespace)MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace()));
        List elements = xp.evaluate((Object)document);
        for (Element element : elements) {
            String name = FlowNameUtils.decode(element.getAttributeValue("name"));
            try {
                APIKitFlow flow = APIKitFlow.buildFromName(name, this.includedApis.keySet());
                ApikitMainFlowContainer api = this.includedApis.get(flow.getConfigRef());
                if (api == null) {
                    throw new IllegalStateException(String.format("No APIKit configuration found for flow %s", name));
                }
                if (api.getPath() == null) {
                    throw new IllegalStateException("Api path is invalid");
                }
                String resource = flow.getResource().startsWith("/") ? flow.getResource() : "/" + flow.getResource();
                String path = APIKitTools.getCompletePathFromBasePathAndPath(api.getHttpListenerConfig().getBasePath(), api.getPath());
                entries.add(new ResourceActionMimeTypeTriplet(api, path + resource, flow.getAction(), flow.getMimeType()));
            }
            catch (IllegalArgumentException e) {
                LOGGER.info("Flow named '" + name + "' is not an APIKit Flow because it does not follow APIKit naming convention.");
            }
        }
        return entries;
    }
}

