/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.scopes;

import java.util.Arrays;
import java.util.List;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.mule.tools.apikit.output.MuleConfigGenerator;
import org.mule.tools.apikit.output.scopes.Scope;

public class ErrorHandlerScope
implements Scope {
    private Element errorHandler;

    public static ErrorHandlerScope createForConsoleFlow(boolean isMuleEE) {
        List<StatusCodeMapping> statusCodeMappings = Arrays.asList(new StatusCodeMapping(404, "APIKIT:NOT_FOUND", "Resource not found"));
        return new ErrorHandlerScope(statusCodeMappings, isMuleEE);
    }

    public static ErrorHandlerScope createForMainFlow(boolean isMuleEE) {
        List<StatusCodeMapping> statusCodeMappings = Arrays.asList(new StatusCodeMapping(400, "APIKIT:BAD_REQUEST", "Bad request"), new StatusCodeMapping(404, "APIKIT:NOT_FOUND", "Resource not found"), new StatusCodeMapping(405, "APIKIT:METHOD_NOT_ALLOWED", "Method not allowed"), new StatusCodeMapping(406, "APIKIT:NOT_ACCEPTABLE", "Not acceptable"), new StatusCodeMapping(415, "APIKIT:UNSUPPORTED_MEDIA_TYPE", "Unsupported media type"), new StatusCodeMapping(501, "APIKIT:NOT_IMPLEMENTED", "Not Implemented"));
        return new ErrorHandlerScope(statusCodeMappings, isMuleEE);
    }

    private ErrorHandlerScope(List<StatusCodeMapping> statusCodeMappings, boolean isMuleEE) {
        this.createErrorHandlerElement(statusCodeMappings, isMuleEE);
    }

    private void createErrorHandlerElement(List<StatusCodeMapping> statusCodeMappings, boolean isMuleEE) {
        this.errorHandler = new Element("error-handler", MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
        for (StatusCodeMapping statusCodeMapping : statusCodeMappings) {
            Element errorMapping = new Element("on-error-propagate", MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
            errorMapping.setAttribute("type", statusCodeMapping.getErrorType());
            if (isMuleEE) {
                this.generateErrorHandlingForEE(statusCodeMapping, errorMapping);
            } else {
                this.generateErrorHandlingForCE(statusCodeMapping, errorMapping);
            }
            this.errorHandler.addContent((Content)errorMapping);
        }
    }

    private void generateErrorHandlingForCE(StatusCodeMapping statusCodeMapping, Element errorMapping) {
        Element contentTypeHeader = new Element("set-variable", MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
        contentTypeHeader.setAttribute("variableName", "outboundHeaders");
        contentTypeHeader.setAttribute("value", "#[{'Content-Type':'application/json'}]");
        errorMapping.addContent((Content)contentTypeHeader);
        Element setPayload = new Element("set-payload", MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
        setPayload.setAttribute("value", "{ \"message\": \"" + statusCodeMapping.getMessage() + "\" }");
        errorMapping.addContent((Content)setPayload);
        Element statusCodeVariable = new Element("set-variable", MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
        statusCodeVariable.setAttribute("variableName", "httpStatus");
        statusCodeVariable.setAttribute("value", statusCodeMapping.getStatusCode());
        errorMapping.addContent((Content)statusCodeVariable);
    }

    private void generateErrorHandlingForEE(StatusCodeMapping statusCodeMapping, Element errorMapping) {
        Element transform = new Element("transform", MuleConfigGenerator.EE_NAMESPACE.getNamespace());
        transform.addNamespaceDeclaration(MuleConfigGenerator.EE_NAMESPACE.getNamespace());
        Element message = new Element("message", MuleConfigGenerator.EE_NAMESPACE.getNamespace());
        Element setPayload = new Element("set-payload", MuleConfigGenerator.EE_NAMESPACE.getNamespace());
        CDATA cDataSection = new CDATA(this.getTransformText(statusCodeMapping.getMessage()));
        Element variables = new Element("variables", MuleConfigGenerator.EE_NAMESPACE.getNamespace());
        Element statusCodeVariable = new Element("set-variable", MuleConfigGenerator.EE_NAMESPACE.getNamespace());
        statusCodeVariable.setAttribute("variableName", "httpStatus");
        setPayload.addContent((Content)cDataSection);
        statusCodeVariable.addContent(statusCodeMapping.getStatusCode());
        message.addContent((Content)setPayload);
        variables.addContent((Content)statusCodeVariable);
        transform.addContent((Content)message);
        transform.addContent((Content)variables);
        errorMapping.addContent((Content)transform);
    }

    @Override
    public Element generate() {
        return this.errorHandler;
    }

    private String getTransformText(String message) {
        return "%dw 2.0\noutput application/json\n---\n{message: \"" + message + "\"}\n";
    }

    public static class StatusCodeMapping {
        private final int statusCode;
        private final String errorType;
        private final String message;

        public StatusCodeMapping(int statusCode, String errorType, String message) {
            this.statusCode = statusCode;
            this.errorType = errorType;
            this.message = message;
        }

        public String getStatusCode() {
            return Integer.toString(this.statusCode);
        }

        public String getErrorType() {
            return this.errorType;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

