/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.scopes;

import org.jdom2.Content;
import org.jdom2.Element;
import org.mule.tools.apikit.output.MuleConfigGenerator;

public class MainFlowsUtils {
    public static final String DEFAULT_STATUS_CODE_SUCCESS_VALUE = "#[vars.httpStatus default 200]";
    public static final String DEFAULT_STATUS_CODE_ERROR_VALUE = "#[vars.httpStatus default 500]";
    public static final String DEFAULT_OUTBOUND_HEADERS_MAP_VALUE = "#[vars.outboundHeaders default {}]";
    public static final String DEFAULT_ERROR_BODY_CONTENT = "#[payload]";

    private MainFlowsUtils() {
    }

    public static Element generateListenerSource(String httpListenerConfigRef, String path) {
        Element httpListener = new Element("listener", MuleConfigGenerator.HTTP_NAMESPACE.getNamespace());
        httpListener.setAttribute("config-ref", httpListenerConfigRef);
        httpListener.setAttribute("path", path);
        Element headers = new Element("headers", MuleConfigGenerator.HTTP_NAMESPACE.getNamespace());
        headers.setText(DEFAULT_OUTBOUND_HEADERS_MAP_VALUE);
        Element errorHeaders = new Element("headers", MuleConfigGenerator.HTTP_NAMESPACE.getNamespace());
        errorHeaders.setText(DEFAULT_OUTBOUND_HEADERS_MAP_VALUE);
        Element responseBuilder = new Element("response", MuleConfigGenerator.HTTP_NAMESPACE.getNamespace());
        responseBuilder.setAttribute("statusCode", DEFAULT_STATUS_CODE_SUCCESS_VALUE);
        responseBuilder.addContent((Content)headers);
        httpListener.addContent((Content)responseBuilder);
        Element errorBody = new Element("body", MuleConfigGenerator.HTTP_NAMESPACE.getNamespace());
        errorBody.addContent(DEFAULT_ERROR_BODY_CONTENT);
        Element errorResponseBuilder = new Element("error-response", MuleConfigGenerator.HTTP_NAMESPACE.getNamespace());
        errorResponseBuilder.setAttribute("statusCode", DEFAULT_STATUS_CODE_ERROR_VALUE);
        errorResponseBuilder.addContent((Content)errorBody);
        errorResponseBuilder.addContent((Content)errorHeaders);
        httpListener.addContent((Content)errorResponseBuilder);
        return httpListener;
    }
}

