/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input.parsers;

import java.util.LinkedList;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.tools.apikit.input.parsers.MuleConfigFileParser;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.APIKitConfig;

public class APIKitConfigParser
implements MuleConfigFileParser<List<APIKitConfig>> {
    private static final XPathExpression<Element> APIKIT_CONFIG_EXPRESSION = APIKitConfigParser.getCompiledExpression();

    @Override
    public List<APIKitConfig> parse(Document document) {
        LinkedList<APIKitConfig> apikitConfigs = new LinkedList<APIKitConfig>();
        List elements = APIKIT_CONFIG_EXPRESSION.evaluate((Object)document);
        for (Element element : elements) {
            Attribute name = element.getAttribute("name");
            Attribute api = element.getAttribute("api");
            Attribute raml = element.getAttribute("raml");
            Attribute extensionEnabled = element.getAttribute("extensionEnabled");
            Attribute outboundHeadersMapName = element.getAttribute("outboundHeadersMapName");
            Attribute httpStatusVarName = element.getAttribute("httpStatusVarName");
            APIKitConfig apiKitConfig = new APIKitConfig();
            if (api != null) {
                apiKitConfig.setApi(api.getValue());
            } else if (raml != null) {
                apiKitConfig.setRaml(raml.getValue());
            } else {
                throw new IllegalArgumentException("api attribute is required on apikit configuration");
            }
            apiKitConfig.setName(name != null ? name.getValue() : "noNameConfig");
            if (outboundHeadersMapName != null) {
                apiKitConfig.setOutboundHeadersMapName(outboundHeadersMapName.getValue());
            }
            if (extensionEnabled != null) {
                apiKitConfig.setExtensionEnabled(Boolean.valueOf(extensionEnabled.getValue()));
            }
            if (httpStatusVarName != null) {
                apiKitConfig.setHttpStatusVarName(httpStatusVarName.getValue());
            }
            apikitConfigs.add(apiKitConfig);
        }
        return apikitConfigs;
    }

    private static XPathExpression<Element> getCompiledExpression() {
        return XPathFactory.instance().compile("//*/*[local-name()='config']", Filters.element((Namespace)APIKitTools.API_KIT_NAMESPACE.getNamespace()));
    }
}

