/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import java.util.Objects;
import org.jdom2.Element;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.HttpListenerConnection;
import org.mule.tools.apikit.output.scopes.HttpListenerConfigScope;
import org.mule.tools.apikit.output.scopes.Scope;

public class HttpListenerConfig
implements Scope {
    public static final String ELEMENT_NAME = "listener-config";
    public static final String DEFAULT_CONFIG_NAME = "httpListenerConfig";
    private String name;
    private String basePath;
    private HttpListenerConnection connection;
    private boolean isPersisted = false;

    public HttpListenerConfig(String name, String baseUri) {
        this.name = name;
        String host = APIKitTools.getHostFromUri(baseUri);
        String port = APIKitTools.getPortFromUri(baseUri);
        String protocol = APIKitTools.getProtocolFromUri(baseUri);
        this.basePath = APIKitTools.getPathFromUri(baseUri, false);
        this.connection = new HttpListenerConnection.Builder(host, port, protocol).build();
    }

    public HttpListenerConfig(String name) {
        this(name, "/", new HttpListenerConnection.Builder("0.0.0.0", String.valueOf(8081), "HTTP").build());
    }

    public HttpListenerConfig(String name, String host, String port, String protocol, String basePath) {
        this(name, basePath, new HttpListenerConnection.Builder(host, port, protocol).build());
    }

    public HttpListenerConfig(String name, String basePath, HttpListenerConnection httpListenerConnection) {
        this.name = name;
        this.basePath = basePath;
        this.connection = httpListenerConnection;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHost() {
        return this.connection.getHost();
    }

    public String getPort() {
        return this.connection.getPort();
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public boolean isPersisted() {
        return this.isPersisted;
    }

    public void setPersisted(boolean isGenerated) {
        this.isPersisted = isGenerated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpListenerConfig that = (HttpListenerConfig)o;
        return this.isPersisted == that.isPersisted && Objects.equals(this.name, that.name) && Objects.equals(this.basePath, that.basePath) && Objects.equals(this.connection, that.connection);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.basePath, this.connection, this.isPersisted);
    }

    @Override
    public Element generate() {
        HttpListenerConfigScope httpListenerScope = new HttpListenerConfigScope(this);
        return httpListenerScope.generate();
    }
}

