/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import java.util.ArrayList;
import java.util.List;
import org.mule.apikit.model.ApiSpecification;
import org.mule.tools.apikit.model.MuleConfig;
import org.mule.tools.apikit.model.MuleDomain;

public class ScaffoldingConfiguration {
    private final ApiSpecification api;
    private final List<MuleConfig> configurations;
    private final MuleDomain domain;
    private final boolean showConsole;

    private ScaffoldingConfiguration(ApiSpecification api, List<MuleConfig> configs, MuleDomain domain, boolean showConsole) {
        this.api = api;
        this.configurations = configs;
        this.domain = domain;
        this.showConsole = showConsole;
    }

    public ApiSpecification getApi() {
        return this.api;
    }

    public List<MuleConfig> getMuleConfigurations() {
        return this.configurations;
    }

    public MuleDomain getDomain() {
        return this.domain;
    }

    public boolean isShowConsole() {
        return this.showConsole;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ApiSpecification api;
        private List<MuleConfig> muleConfigurations = new ArrayList<MuleConfig>();
        private MuleDomain domain = MuleDomain.builder().build();
        private boolean showConsole = true;

        public Builder withApi(ApiSpecification api) {
            this.api = api;
            return this;
        }

        public Builder withMuleConfigurations(List<MuleConfig> configurations) {
            this.muleConfigurations.addAll(configurations);
            return this;
        }

        public Builder withDomain(MuleDomain domain) {
            this.domain = domain;
            return this;
        }

        public Builder withShowConsole(boolean showConsole) {
            this.showConsole = showConsole;
            return this;
        }

        public ScaffoldingConfiguration build() {
            return new ScaffoldingConfiguration(this.api, this.muleConfigurations, this.domain, this.showConsole);
        }
    }
}

