/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.model.ApikitMainFlowContainer;
import org.mule.tools.apikit.model.Flow;
import org.mule.tools.apikit.model.MainFlow;
import org.mule.tools.apikit.model.MuleConfig;
import org.mule.tools.apikit.model.MuleConfigBuilder;
import org.mule.tools.apikit.model.RuntimeEdition;
import org.mule.tools.apikit.model.ScaffolderContext;
import org.mule.tools.apikit.output.GenerationModel;
import org.mule.tools.apikit.output.NamespaceWithLocation;
import org.mule.tools.apikit.output.scopes.APIKitFlowScope;
import org.mule.tools.apikit.output.scopes.ConsoleFlowScope;
import org.mule.tools.apikit.output.scopes.FlowScope;
import org.mule.tools.apikit.output.scopes.MuleScope;

public class MuleConfigGenerator {
    public static final NamespaceWithLocation XMLNS_NAMESPACE = new NamespaceWithLocation(Namespace.getNamespace((String)"http://www.mulesoft.org/schema/mule/core"), "http://www.mulesoft.org/schema/mule/core/current/mule.xsd");
    public static final NamespaceWithLocation XSI_NAMESPACE = new NamespaceWithLocation(Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"), null);
    public static final NamespaceWithLocation HTTP_NAMESPACE = new NamespaceWithLocation(Namespace.getNamespace((String)"http", (String)"http://www.mulesoft.org/schema/mule/http"), "http://www.mulesoft.org/schema/mule/http/current/mule-http.xsd");
    public static final NamespaceWithLocation EE_NAMESPACE = new NamespaceWithLocation(Namespace.getNamespace((String)"ee", (String)"http://www.mulesoft.org/schema/mule/ee/core"), "http://www.mulesoft.org/schema/mule/ee/core/current/mule-ee.xsd");
    public static final NamespaceWithLocation DOC_NAMESPACE = new NamespaceWithLocation(Namespace.getNamespace((String)"doc", (String)"http://www.mulesoft.org/schema/mule/documentation"), "");
    private static final String DEFAULT_APIKIT_CONFIG_NAME = "no_named_config";
    private final List<GenerationModel> flowEntriesDiff;
    private final List<ApikitMainFlowContainer> apiContainers;
    private List<MuleConfig> muleConfigsInApp = new ArrayList<MuleConfig>();
    private ScaffolderContext scaffolderContext;
    private boolean showConsole;

    public MuleConfigGenerator(List<ApikitMainFlowContainer> apiContainers, List<GenerationModel> flowEntriesDiff, List<MuleConfig> muleConfigsInApp, ScaffolderContext scaffolderContext, boolean includeConsole) {
        this.apiContainers = apiContainers;
        this.flowEntriesDiff = flowEntriesDiff;
        this.muleConfigsInApp.addAll(muleConfigsInApp);
        this.scaffolderContext = scaffolderContext;
        this.showConsole = includeConsole;
    }

    public List<MuleConfig> generate() {
        Set<MuleConfig> updatedMuleConfigs = this.getConfigsFromApiContainers();
        this.generateMissingFlowEntriesInMuleConfigs();
        Map<String, MuleConfig> indexByApikitConfigName = this.createIndexOfConfigurationsWithApikitConfig();
        if (CollectionUtils.isEmpty(indexByApikitConfigName.entrySet())) {
            return new ArrayList<MuleConfig>(updatedMuleConfigs);
        }
        Map<String, Element> indexOfApikitRouterConfigByRefName = this.createIndexOfRouterReferences();
        if (CollectionUtils.isEmpty(indexOfApikitRouterConfigByRefName.entrySet())) {
            return new ArrayList<MuleConfig>(updatedMuleConfigs);
        }
        if (!this.isThereConfigsInIntersection(indexByApikitConfigName, indexOfApikitRouterConfigByRefName)) {
            return new ArrayList<MuleConfig>(updatedMuleConfigs);
        }
        updatedMuleConfigs.addAll(this.getCrossReferencedConfigsUpdated(indexByApikitConfigName, indexOfApikitRouterConfigByRefName));
        return new ArrayList<MuleConfig>(updatedMuleConfigs);
    }

    private boolean isThereConfigsInIntersection(Map<String, MuleConfig> muleConfigsContainingApikitConfig, Map<String, Element> muleConfigsReferencingApikitConfig) {
        Set<String> muleConfigsCandidateToUpdate = muleConfigsContainingApikitConfig.keySet();
        muleConfigsCandidateToUpdate.retainAll(muleConfigsReferencingApikitConfig.keySet());
        return CollectionUtils.isNotEmpty(muleConfigsCandidateToUpdate);
    }

    private void generateMissingFlowEntriesInMuleConfigs() {
        if (!this.flowEntriesDiff.isEmpty()) {
            this.flowEntriesDiff.forEach(this::generateFlowEntryInMuleConfig);
        }
    }

    private Map<String, MuleConfig> createIndexOfConfigurationsWithApikitConfig() {
        HashMap<String, MuleConfig> configsWithApikitConfig = new HashMap<String, MuleConfig>();
        for (MuleConfig muleConfig : this.muleConfigsInApp) {
            List<Element> apikitConfigElements = this.getApikitConfigDocumentElement(muleConfig);
            if (CollectionUtils.isEmpty(apikitConfigElements)) continue;
            for (Element configElement : apikitConfigElements) {
                String apikitConfigName = configElement.getAttributeValue("name");
                if (apikitConfigName == null) {
                    apikitConfigName = DEFAULT_APIKIT_CONFIG_NAME;
                }
                configsWithApikitConfig.put(apikitConfigName, muleConfig);
            }
        }
        return configsWithApikitConfig;
    }

    private Map<String, Element> createIndexOfRouterReferences() {
        HashMap<String, Element> refsToApikitConfig = new HashMap<String, Element>();
        for (ApikitMainFlowContainer api : this.apiContainers) {
            List mainFlows = api.getMuleConfig().getMainFlows().stream().filter(flow -> flow.getApikitRouter() != null).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(mainFlows)) continue;
            for (MainFlow mainFlow : mainFlows) {
                String referenceName = mainFlow.getApikitRouter().getContent().getAttributeValue("config-ref");
                if (referenceName == null) {
                    referenceName = DEFAULT_APIKIT_CONFIG_NAME;
                }
                refsToApikitConfig.put(referenceName, api.getConfig().generate());
            }
        }
        return refsToApikitConfig;
    }

    private Set<MuleConfig> getCrossReferencedConfigsUpdated(Map<String, MuleConfig> configsContainingApikitConfig, Map<String, Element> apikitConfigsCandidateToUpdate) {
        HashSet<MuleConfig> updatedMuleConfigs = new HashSet<MuleConfig>();
        for (Map.Entry<String, MuleConfig> muleConfigRef : configsContainingApikitConfig.entrySet()) {
            MuleConfig updatedMuleConfig = this.getUpdatedMuleConfig(muleConfigRef.getValue(), apikitConfigsCandidateToUpdate.get(muleConfigRef.getKey()));
            if (updatedMuleConfig == null) continue;
            updatedMuleConfigs.add(updatedMuleConfig);
        }
        return updatedMuleConfigs;
    }

    private MuleConfig getUpdatedMuleConfig(MuleConfig muleConfig, Element newApikitConfigFromApi) {
        MuleConfig updatedMuleConfig = null;
        List<Element> preExistingApikitConfigs = this.getApikitConfigDocumentElement(muleConfig);
        for (Element preExistingApikitConfig : preExistingApikitConfigs) {
            if (!this.shouldUpdateApikitConfig(newApikitConfigFromApi, preExistingApikitConfig)) continue;
            this.replaceExistingConfigWithNew(newApikitConfigFromApi, preExistingApikitConfig, muleConfig);
            updatedMuleConfig = muleConfig;
        }
        return updatedMuleConfig;
    }

    private Set<MuleConfig> getConfigsFromApiContainers() {
        HashSet<MuleConfig> muleConfigs = new HashSet<MuleConfig>();
        for (ApikitMainFlowContainer api : this.apiContainers) {
            muleConfigs.add(api.getMuleConfig() == null ? this.createMuleConfig(api) : api.getMuleConfig());
        }
        return muleConfigs;
    }

    private void generateFlowEntryInMuleConfig(GenerationModel flowEntry) {
        Element apikitFlowScope = new APIKitFlowScope(flowEntry, this.isMuleEE()).generate();
        MuleConfig mainMuleConfig = flowEntry.getApi().getMuleConfig();
        mainMuleConfig.getContentAsDocument().getRootElement().getContent().add(apikitFlowScope);
        mainMuleConfig.addFlow(new Flow(apikitFlowScope));
    }

    private void replaceExistingConfigWithNew(Element newApikitConfigFromApi, Element preExistingApikitConfig, MuleConfig preExistingMuleConfig) {
        int index = preExistingMuleConfig.getContentAsDocument().getRootElement().indexOf((Content)preExistingApikitConfig);
        preExistingMuleConfig.getContentAsDocument().getRootElement().removeContent(index);
        preExistingMuleConfig.getContentAsDocument().getRootElement().addContent(index, (Content)newApikitConfigFromApi);
    }

    private List<Element> getApikitConfigDocumentElement(MuleConfig config) {
        return config.getContentAsDocument().getRootElement().getChildren("config", APIKitTools.API_KIT_NAMESPACE.getNamespace());
    }

    public MuleConfig createMuleConfig(ApikitMainFlowContainer api) {
        Document muleConfigContent = this.createMuleConfigContent(api);
        MuleConfig config = MuleConfigBuilder.fromDoc(muleConfigContent);
        config.setName(this.createMuleConfigID(api.getId()));
        api.setMuleConfig(config);
        return config;
    }

    private Document createMuleConfigContent(ApikitMainFlowContainer api) {
        Document document = new Document();
        document.setRootElement(new MuleScope(this.isMuleEE(), false).generate());
        MuleConfig muleConfig = MuleConfigBuilder.fromDoc(document);
        muleConfig.setName(this.createMuleConfigID(api.getId()));
        this.addApikitConfiguration(api, muleConfig);
        api.setPath(APIKitTools.addAsteriskToPath(api.getPath()));
        muleConfig.addFlow(new Flow(new FlowScope(api, this.isMuleEE()).generate()));
        this.addHttpListenerConfiguration(api, muleConfig);
        this.addConsoleFlow(api, muleConfig);
        return muleConfig.buildContent();
    }

    private String createMuleConfigID(String id) {
        return id + ".xml";
    }

    private void addApikitConfiguration(ApikitMainFlowContainer api, MuleConfig muleConfig) {
        if (api.getConfig() == null) {
            APIKitConfig apikitConfig = new APIKitConfig();
            apikitConfig.setApi(api.getApiFilePath());
            apikitConfig.setName(api.getId() + "-" + "config");
            api.setConfig(apikitConfig);
            muleConfig.addConfig(api.getConfig());
        }
    }

    private void addHttpListenerConfiguration(ApikitMainFlowContainer api, MuleConfig muleConfig) {
        if (!muleConfig.getHttpListenerConfigs().contains(api.getHttpListenerConfig())) {
            muleConfig.addHttpListener(api.getHttpListenerConfig());
        }
    }

    private void addConsoleFlow(ApikitMainFlowContainer api, MuleConfig muleConfig) {
        if (this.showConsole) {
            muleConfig.addFlow(new Flow(new ConsoleFlowScope(api, this.isMuleEE()).generate()));
        }
    }

    private boolean isMuleEE() {
        return this.scaffolderContext.getRuntimeEdition() == RuntimeEdition.EE;
    }

    private boolean shouldUpdateApikitConfig(Element apikitConfigFromApi, Element apikitConfigFromMuleConfig) {
        return apikitConfigFromApi.getAttributeValue("name").equals(apikitConfigFromMuleConfig.getAttributeValue("name")) && apikitConfigFromApi.getAttributes().stream().anyMatch(attribute -> this.lookForDifferences(apikitConfigFromMuleConfig.getAttribute(attribute.getName()), (Attribute)attribute));
    }

    private boolean lookForDifferences(Attribute existingAttribute, Attribute attribute) {
        return existingAttribute == null || this.attributeHasChanged(attribute.getValue(), existingAttribute.getValue());
    }

    private boolean attributeHasChanged(String currentAttribute, String incomingAttribute) {
        String normalizedCurrentAttribute = this.normalizePath(currentAttribute);
        String normalizedIncomingAttribute = this.normalizePath(incomingAttribute);
        boolean attributesExist = StringUtils.isNotEmpty((CharSequence)normalizedCurrentAttribute) && StringUtils.isNotEmpty((CharSequence)normalizedIncomingAttribute);
        return attributesExist && !normalizedCurrentAttribute.contains(normalizedIncomingAttribute);
    }

    private String normalizePath(String path) {
        return StringUtils.isNotEmpty((CharSequence)path) ? path.replace("\\", "/") : path;
    }
}

