/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.mule.tools.apikit.model.ApikitMainFlowContainer;
import org.mule.tools.apikit.model.MuleConfig;
import org.mule.tools.apikit.model.MuleConfigBuilder;
import org.mule.tools.apikit.model.MunitScaffolderContext;
import org.mule.tools.apikit.model.ScaffolderResource;
import org.mule.tools.apikit.output.GenerationModel;
import org.mule.tools.apikit.output.NamespaceWithLocation;
import org.mule.tools.apikit.output.scopes.HttpRequestConfigScope;
import org.mule.tools.apikit.output.scopes.MuleScope;
import org.mule.tools.apikit.output.scopes.MunitConfigScope;
import org.mule.tools.apikit.output.scopes.MunitTestFlowScope;

public class MunitTestSuiteGenerator {
    public static final NamespaceWithLocation MUNIT_NAMESPACE = new NamespaceWithLocation(Namespace.getNamespace((String)"munit", (String)"http://www.mulesoft.org/schema/mule/munit"), "http://www.mulesoft.org/schema/mule/munit/current/mule-munit.xsd");
    public static final NamespaceWithLocation MUNIT_TOOLS_NAMESPACE = new NamespaceWithLocation(Namespace.getNamespace((String)"munit-tools", (String)"http://www.mulesoft.org/schema/mule/munit-tools"), "http://www.mulesoft.org/schema/mule/munit-tools/current/mule-munit-tools.xsd");
    private final List<GenerationModel> flowEntries;
    private MunitScaffolderContext scaffolderContext;
    private String mainFlowName;
    private final Set<ScaffolderResource> generatedResources = new HashSet<ScaffolderResource>();

    public MunitTestSuiteGenerator(List<GenerationModel> flowEntries, MunitScaffolderContext scaffolderContext, String mainFlowName) {
        this.flowEntries = flowEntries;
        this.scaffolderContext = scaffolderContext;
        this.mainFlowName = mainFlowName;
    }

    public List<ScaffolderResource> getGeneratedResources() {
        return Collections.unmodifiableList(Lists.newArrayList(this.generatedResources));
    }

    public List<MuleConfig> generate() {
        HashSet<MuleConfig> muleConfigs = new HashSet<MuleConfig>();
        for (GenerationModel flowEntry : this.flowEntries) {
            MuleConfig muleConfig;
            ApikitMainFlowContainer api = flowEntry.getApi();
            MuleConfig muleConfig2 = muleConfig = api.getMuleConfig() != null ? api.getMuleConfig() : this.createMunitMuleConfig(api);
            if (api.getConfig() == null) {
                api.setDefaultAPIKitConfig();
                this.addMunitConfig(muleConfig);
                this.addHttpRequestConfig(api, muleConfig);
            }
            this.addMunitTests(muleConfig, flowEntry);
            muleConfigs.add(muleConfig);
        }
        return Lists.newArrayList(muleConfigs);
    }

    private MuleConfig createMunitMuleConfig(ApikitMainFlowContainer apikitMainFlow) {
        Document document = new Document();
        document.setRootElement(new MuleScope(false, true).generate());
        MuleConfig muleConfig = MuleConfigBuilder.fromDoc(document);
        muleConfig.setName(this.scaffolderContext.getMunitSuiteName());
        apikitMainFlow.setMuleConfig(muleConfig);
        return muleConfig;
    }

    private void addMunitConfig(MuleConfig muleConfig) {
        Element rootElement = muleConfig.getContentAsDocument().getRootElement();
        Element munitConfigElement = new MunitConfigScope(this.scaffolderContext.getMunitSuiteName()).generate();
        rootElement.addContent((Content)munitConfigElement);
    }

    private void addHttpRequestConfig(ApikitMainFlowContainer apikitMainFlowContainer, MuleConfig muleConfig) {
        Element rootElement = muleConfig.getContentAsDocument().getRootElement();
        Element httpRequestElement = new HttpRequestConfigScope(apikitMainFlowContainer).generate();
        rootElement.addContent((Content)httpRequestElement);
    }

    private void addMunitTests(MuleConfig muleConfig, GenerationModel flowEntry) {
        MunitTestFlowScope testFlowScope = new MunitTestFlowScope(flowEntry, this.mainFlowName);
        testFlowScope.setCreateResourceFiles(this.scaffolderContext.shouldCreateMunitResources());
        muleConfig.getContentAsDocument().getRootElement().addContent(testFlowScope.generateTests());
        this.generatedResources.addAll(testFlowScope.getGeneratedResources());
    }
}

