/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.scopes;

import org.apache.commons.lang.StringUtils;
import org.jdom2.Element;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.output.scopes.Scope;

public class APIKitConfigScope
implements Scope {
    private final APIKitConfig config;

    public APIKitConfigScope(APIKitConfig config) {
        this.config = config;
    }

    @Override
    public Element generate() {
        if (this.config == null) {
            return null;
        }
        Element apikitConfig = new Element("config", APIKitTools.API_KIT_NAMESPACE.getNamespace());
        if (!StringUtils.isEmpty((String)this.config.getName())) {
            apikitConfig.setAttribute("name", this.config.getName());
        }
        if (this.config.getApi() != null) {
            apikitConfig.setAttribute("api", this.config.getApi());
        }
        if (this.config.getRaml() != null) {
            apikitConfig.setAttribute("raml", this.config.getRaml());
        }
        if (this.config.isExtensionEnabled() != null) {
            apikitConfig.setAttribute("extensionEnabled", String.valueOf(this.config.isExtensionEnabled()));
        }
        if (this.config.getOutboundHeadersMapName() != null) {
            apikitConfig.setAttribute("outboundHeadersMapName", this.config.getOutboundHeadersMapName());
        }
        if (this.config.getHttpStatusVarName() != null) {
            apikitConfig.setAttribute("httpStatusVarName", this.config.getHttpStatusVarName());
        }
        if (this.config.getDisableValidations() != null) {
            apikitConfig.setAttribute("disableValidations", this.config.getDisableValidations());
        }
        return apikitConfig;
    }
}

