/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit;

import java.util.Arrays;
import java.util.List;
import org.mule.tools.apikit.input.MuleConfigParser;
import org.mule.tools.apikit.input.RAMLFilesParser;
import org.mule.tools.apikit.model.APIFactory;
import org.mule.tools.apikit.model.ApikitMainFlowContainer;
import org.mule.tools.apikit.model.MuleConfig;
import org.mule.tools.apikit.model.Scaffolder;
import org.mule.tools.apikit.model.ScaffolderContext;
import org.mule.tools.apikit.model.ScaffolderResult;
import org.mule.tools.apikit.model.ScaffoldingConfiguration;
import org.mule.tools.apikit.model.ScaffoldingError;
import org.mule.tools.apikit.model.ScaffoldingResult;
import org.mule.tools.apikit.output.GenerationModel;
import org.mule.tools.apikit.output.GenerationStrategy;
import org.mule.tools.apikit.output.MuleConfigGenerator;

public final class MainAppScaffolder
implements Scaffolder {
    private static final GenerationStrategy GENERATOR = new GenerationStrategy();
    private final ScaffolderContext scaffolderContext;

    public MainAppScaffolder(ScaffolderContext scaffolderContext) {
        this.scaffolderContext = scaffolderContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScaffoldingResult run(ScaffoldingConfiguration config) {
        ScaffolderResult.Builder scaffolderResultBuilder = ScaffolderResult.builder();
        try {
            APIFactory apiFactory = new APIFactory(config.getDomain().getHttpListenerConfigs());
            List<MuleConfig> muleConfigs = config.getMuleConfigurations();
            MuleConfigParser muleConfigParser = new MuleConfigParser(apiFactory, config.getApi().getLocation(), muleConfigs);
            RAMLFilesParser ramlFilesParser = new RAMLFilesParser(apiFactory, config.getApi());
            List<ApikitMainFlowContainer> includedApis = ramlFilesParser.getApisAsList();
            List<GenerationModel> generationModels = GENERATOR.generate(ramlFilesParser.getEntries(), muleConfigParser.getIncludedApis(), muleConfigParser.getEntries());
            MuleConfigGenerator muleConfigGenerator = new MuleConfigGenerator(includedApis, generationModels, muleConfigs, this.scaffolderContext, config.isShowConsole());
            List<MuleConfig> generatedConfigs = muleConfigGenerator.generate();
            scaffolderResultBuilder.withGeneratedConfigs(generatedConfigs);
        }
        catch (Exception e) {
            List<ScaffoldingError> errors = Arrays.asList(new ScaffoldingError(e.getMessage()));
            scaffolderResultBuilder.withErrors(errors);
        }
        finally {
            return scaffolderResultBuilder.build();
        }
    }
}

