/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.mule.tools.apikit.input.parsers.HttpListenerConfigParser;
import org.mule.tools.apikit.model.HttpListenerConfig;
import org.mule.tools.apikit.model.MuleConfigBuilder;
import org.mule.tools.apikit.model.WithConfigs;

public class MuleDomain
implements WithConfigs {
    private List<HttpListenerConfig> configurations;

    MuleDomain(List<HttpListenerConfig> configurations) {
        this.configurations = configurations;
    }

    public String getName() {
        return "APP_DOMAIN";
    }

    @Override
    public List<HttpListenerConfig> getHttpListenerConfigs() {
        return Collections.unmodifiableList(this.configurations);
    }

    public static MuleDomain fromInputStream(InputStream content) throws Exception {
        return new MuleDomain(MuleDomain.parseHttpListenerConfigs(content));
    }

    private static List<HttpListenerConfig> parseHttpListenerConfigs(InputStream content) throws JDOMException, IOException {
        SAXBuilder builder = MuleConfigBuilder.getSaxBuilder();
        Document contentAsDocument = builder.build(content);
        content.close();
        return new HttpListenerConfigParser().parse(contentAsDocument);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private InputStream content;
        private List<HttpListenerConfig> configurations = new ArrayList<HttpListenerConfig>();

        public Builder withContent(InputStream content) {
            this.content = content;
            return this;
        }

        public Builder withConfigurations(List<HttpListenerConfig> configurations) {
            this.configurations = configurations;
            return this;
        }

        public MuleDomain build() {
            try {
                if (this.content != null && this.configurations == null) {
                    this.configurations = MuleDomain.parseHttpListenerConfigs(this.content);
                }
                return new MuleDomain(this.configurations == null ? new ArrayList() : this.configurations);
            }
            catch (IOException | JDOMException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

